﻿#include "fmp_vip_p.h"
#include "fmp_ve_handlers.h"

class ctkPluginContext;

FMPVip::FMPVip(ctkPluginContext *context)
    : FMPVipInterface(context),
      _inited(false),
      d_ptr(new FMPVipPrivate(this))
{
    FMPStartEventHandler *handler = new FMPStartEventHandler(_ctx, this);

    FMPLoggerInterface::InitContext(context);
}

FMPVip::~FMPVip()
{
    StopService();

    FMPLoggerInterface::InitContext(nullptr, false);

    if (d_ptr) {
        delete d_ptr;
        d_ptr = nullptr;
    }
}

void FMPVip::InitService()
{
    d_func()->Init();
}

void FMPVip::UninitService()
{
    if (_inited) {
        d_func()->Uninit();
    }
}
