#ifndef FMBACKUP_H
#define FMBACKUP_H
#include <QSqlDatabase>
#include <QSqlRecord>

class FMBackup
{
public:
    static FMBackup* instance();
    bool updateReqData(const int id, const QString url, const QString &reqData);
    bool removeReqData(const int &id);
    int insertNewRow();
    bool insertNewOrder(const QString &fmId, const QByteArray &orderContent);
    QByteArray getOrderByFmId(const QString &fmId);

    QSqlQuery reqDataQuery() const;
    bool reset();
private:
    FMBackup();
    static FMBackup* _instance;
    QSqlDatabase _db;


    bool connect();
    bool createDBFile(const QString &dbname);

    bool createTable(const QString &tbName);

private:
    class privateFMBackup
    {
    public:
        ~privateFMBackup()
        {
            if(FMBackup::_instance != nullptr) {
                delete FMBackup::_instance;
                FMBackup::_instance = nullptr;
            }
        }
    };
};

#endif // FMBACKUP_H
