﻿#include "fmbackup.h"
#include "fmp_vip_settings.h"
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlRecord>
#include <QSqlError>
#include <QDir>
#include <QFile>
#include <QApplication>
#include <QDebug>

FMBackup* FMBackup::_instance = nullptr;

FMBackup::FMBackup()
{
    connect();
}

FMBackup* FMBackup::instance()
{
    if(_instance == nullptr) {
        _instance = new FMBackup();
    }
    return _instance;
}

bool FMBackup::connect()
{
    bool isOk;
    QString backupPath = qApp->applicationDirPath()+"/backup/";
    QDir dir;
    if(!dir.exists(backupPath)) {
        dir.mkdir(backupPath);
    }
    QString dbname = backupPath + "backupReq.db";
    if(!QFile::exists(dbname)) {
        isOk = createDBFile(dbname);
    } else {
        _db = QSqlDatabase::addDatabase("QSQLITE", "fmvipbackupdb");
        _db.setDatabaseName(dbname);
        isOk =_db.open();
    }

    FMP_INFO() << QString::fromLocal8Bit("连接数据库：") << dbname;
    if(!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("连接失败：") << _db.lastError().text();
    }

    if(!_db.tables().contains("tbl_req")) {
        createTable("tbl_req");
    }

    if(!_db.tables().contains("tbl_order")) {
        createTable("tbl_order");
    }

    return isOk;
}

bool FMBackup::createDBFile(const QString &dbname)
{
    _db = QSqlDatabase::addDatabase("QSQLITE", "fmvipbackupdb");
    _db.setDatabaseName(dbname);
    _db.open();
    QSqlQuery query(_db);
    bool isOk = createTable("tbl_req");
    isOk &= createTable("tbl_order");

    FMP_INFO() << QString::fromLocal8Bit("创建数据库：") << dbname;
    if (!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("创建数据库失败：") << query.lastError().text();
    }
    return isOk;
}

bool FMBackup::createTable(const QString &tbName)
{
    QString sql;
    if(tbName == "tbl_req") {
        sql = QString("create table tbl_req(id integer PRIMARY KEY autoincrement, url varchar(200), req text)");
    } else if(tbName == "tbl_order") {
        sql = QString("create table tbl_order(id integer PRIMARY KEY autoincrement, fmId varchar(40), orderContent text)");
    }

    QSqlQuery query(_db);
    //  创建表
    bool isOk = query.exec(sql);
    if (!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("创建表失败：") << query.lastError().text();
    }
    return isOk;
}

int FMBackup::insertNewRow()
{
    if(!_db.isOpen()) {
        connect();
    }
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("insert into tbl_req('url','req') values('','');"));
    isOk &= query.exec("select last_insert_rowid();");

    int id = -1;
    if(isOk && query.next()) {
        id = query.record().value(0).toInt();
    }

    return id;
}

bool FMBackup::updateReqData(const int id, const QString url, const QString &reqData)
{
    if(!_db.isOpen()) {
        connect();
    }
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("update tbl_req set url = '%1', req='%2' where id=%3")
                           .arg(url)
                           .arg(reqData)
                           .arg(id));

    FMP_INFO() << QString::fromLocal8Bit("备份数据：") << reqData;
    if (!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("备份失败：") << query.lastError().text();
    }
    return isOk;
}

bool FMBackup::removeReqData(const int &id)
{
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("delete from tbl_req where id==%1").arg(id));
    if(!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("删除数据时出现错误：") << query.lastError().text();
    }
    return isOk;
}

QSqlQuery FMBackup::reqDataQuery() const
{
    QSqlQuery query(_db);
    bool isOk = query.exec("select * from tbl_req");
    if(!isOk) {
        FMP_WARN() << QString::fromLocal8Bit("查询数据时出现错误：") << query.lastError().text();
    }
    return query;
}

bool FMBackup::reset()
{
    QSqlQuery query(_db);
    bool isOk = query.exec("VACUUM");
    FMP_INFO() << QString::fromLocal8Bit("数据库重置: ") << isOk;
    return isOk;
}

bool FMBackup::insertNewOrder(const QString &fmId, const QByteArray &orderContent)
{
    if(!_db.isOpen()) {
        connect();
    }
    QSqlQuery query(_db);
    bool isOk = query.exec(QString("insert into tbl_order('fmId','orderContent') values('%1','%2');").arg(fmId).arg(QString(orderContent)));
    if(!isOk) {
        FMP_ERROR() << QString::fromLocal8Bit("插入订单数据失败：fmId: %1, orderContent: %2。失败原因：%3")
                       .arg(fmId).arg(QString(orderContent)).arg(query.lastError().text());
    }
    return isOk;
}

QByteArray FMBackup::getOrderByFmId(const QString &fmId)
{
    if(!_db.isOpen()) {
        connect();
    }

    QSqlQuery query(_db);
    bool isOk = query.exec(QString("select * from tbl_order where (tbl_order.fmId='%1')").arg(fmId));
    if(!isOk) {
        FMP_ERROR() << QString::fromLocal8Bit("查询订单失败：fmId: %1。失败原因：%2").arg(fmId).arg(query.lastError().text());
    }

    QByteArray orderContent;
    while(query.next())
    {
        orderContent = query.record().value("orderContent").toByteArray();
    }
    FMP_INFO() << QString::fromLocal8Bit("查询到订单信息：%1。").arg(QString(orderContent));
    return orderContent;
}
