﻿#include "fmviporder.h"
#include "fmmsgwnd.h"
#include "fmcouponwidget.h"
#include "ui_fmviporder.h"
#include <QScrollBar>
#include <QJsonArray>

FMVipOrder::FMVipOrder(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipOrder)
{
    ui->setupUi(this);
    orderInfo = nullptr;
}

FMVipOrder::~FMVipOrder()
{
    del_p(orderInfo);
    delete ui;
}

void FMVipOrder::initWnd(Session *se)
{
    //天福目前不使用积分支付和满减，故隐藏相关控件
    ui->pay_chk->hide();
    ui->standard_label->hide();
    
    this->_session = se;
    QString operator_id = session()->data("operator_id").toString();
    QString business_date = session()->data("business_date").toString();
    QString fm_id = session()->data("fm_open_id").toString();
    QString name = session()->data("name").toString();
    
    QString amount_str = QString::number(session()->data("amount").toInt());
    QString score_str = QString::number(session()->data("score").toInt());
    
    int needPay = session()->data("need_amount").toInt();
    QString needPay_str = QString::number(needPay);
    
    orderInfo = new FMVipOrder::OrderInfo(amount_str, score_str, needPay_str);
    orderInfo->setCouponMap(session()->getCouponMap("payCouponMap"));
    
    ui->store_label->setText(session()->data("store_id").toString());
    ui->pos_label->setText(session()->data("pos_id").toString());
    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(fm_id);
    ui->point_label->setText(score_str);
    ui->balance_label->setText(orderInfo->getAmountStr());
    ui->price_label->setText(orderInfo->getNeedPayStr());
    ui->name_label->setText(name);

    initCouponItems();
    connect(ui->coupon_page, SIGNAL(itemClicked(QListWidgetItem*)), this, SLOT(onItemClicked(QListWidgetItem*)));

    ui->pay_chk->setText(QString::fromLocal8Bit("使用积分抵用 %1 元").arg(orderInfo->getScoreAmount()));

    oldPayText = DOUBLE_STR(orderInfo->getMaxWillPay());
    ui->pay_edit->setText(oldPayText);
    QRegExp regexp("^[0-9]+(.[0-9]{2})?$");
    ui->pay_edit->setValidator(new QRegExpValidator(regexp));
    
    setWillPayText();
}

void FMVipOrder::on_pay_btn_clicked()
{
    session()->addData("payCouponMap", orderInfo->selectCouponMap);
    int codeAmount = orderInfo->getPayAmount(ui->pay_edit->text());
    session()->addData("codeAmount", codeAmount);
    session()->addData("isUseScore", orderInfo->isUseScore());

    this->setEnabled(false);

    setIsBusy(true);

    emit pay();
}

void FMVipOrder::on_pay_chk_clicked(bool checked)
{
    orderInfo->setUseScore(checked);
    setWillPayText();
}

void FMVipOrder::onItemClicked(QListWidgetItem *item)
{
    QString code = item->data(Qt::UserRole).toString();
    if(orderInfo->couponMap()[code].typeModeFlag == 20003) //代金券
    {
        // 如果代金券已被选中则取消，否则选中
        if(orderInfo->selectCouponMap.contains(code)) {
            ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-left: 5 solid rgb(255, 170, 37);}");
            orderInfo->selectCouponMap.remove(code);
            orderInfo->enoughCoupon();  // 计算一下当前代金券金额
        }else{
            if(orderInfo->couponMap()[code].compatible_flag == 0)
            {
                FMMsgWnd::WarningWnd(QString::fromLocal8Bit("请注意该券不能与其他券叠加使用！"), this);
                return ;
            }
            ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-image: url(:/coupon_select.png);}");
            orderInfo->selectCouponMap[code] = orderInfo->couponMap()[code];
            qDebug() << orderInfo->selectCouponMap[code].disAmount;
            if(orderInfo->enoughCoupon())
            {
                FMMsgWnd::WarningWnd(QString::fromLocal8Bit("请注意代金券总额已超过待付金额！"), this);
            }
        }
    }
    else if(orderInfo->couponMap()[code].typeModeFlag == 20004) //商品券
    {
        if(orderInfo->selectCouponMap.contains(code))
        {
            ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-left: 5 solid rgb(255, 170, 37);}");
            orderInfo->selectCouponMap.remove(code);
            orderInfo->enoughCoupon();
        }
        else
        {
            if(orderInfo->couponMap()[code].compatible_flag == 0)
            {
                FMMsgWnd::WarningWnd(QString::fromLocal8Bit("请注意该券不能与其他券叠加使用！"), this);
                return ;
            }
            ui->coupon_page->itemWidget(item)->setStyleSheet("#FMCouponWidget{background-color: rgb(255, 255, 255); border: none; border-image: url(:/coupon_select.png);}");
            orderInfo->selectCouponMap[code] = orderInfo->couponMap()[code];
            if(orderInfo->enoughCoupon())
            {
                FMMsgWnd::WarningWnd(QString::fromLocal8Bit("请注意代金券总额已超过待付金额！"), this);
            }
        }
    }
    setWillPayText();
}

void FMVipOrder::initCouponItems()
{
    QMap<QString, Coupon> coupons = session()->getCouponMap("payCouponMap");
    qDebug() << coupons.size();
    foreach(Coupon coupon , coupons.values())
    {
        auto item = new QListWidgetItem();
        item->setData(Qt::UserRole, coupon.code);
        ui->coupon_page->addItem(item);
        ui->coupon_page->update();
        auto itemWidget = new FMCouponWidget(coupon);
        ui->coupon_page->setItemWidget(item, itemWidget);
        //item大小
        item->setSizeHint (itemWidget->size());
    }
}

void FMVipOrder::setWillPayText()
{
    on_pay_edit_textChanged(oldPayText);

    ui->pay_edit->setFocus();
    ui->pay_edit->selectAll();
}

void FMVipOrder::on_coupon_prev_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos - 125);
}

void FMVipOrder::on_coupon_next_btn_clicked()
{
    int pos = ui->coupon_page->verticalScrollBar()->value();
    ui->coupon_page->verticalScrollBar()->setValue(pos + 125);
}

void FMVipOrder::on_pay_edit_textChanged(const QString &text)
{
    double num = text.toDouble();
    double maxPay = orderInfo->getMaxWillPay();
    if (num > maxPay) {
        ui->pay_edit->setText(DOUBLE_STR(maxPay));

        QString maxPay_info = QString::fromLocal8Bit("余额只需支付 %1 元");
        if (maxPay >= orderInfo->getAmountStr().toDouble()) {
            maxPay_info = QString::fromLocal8Bit("余额最多支付 %1 元");
        }
        ui->pay_max->setText(maxPay_info.arg(maxPay));

        ui->pay_edit->setFocus();
        ui->pay_edit->selectAll();
    } else {
        oldPayText = text;
        ui->pay_max->setText("");
    }
}
