﻿#include "fmmsgwnd.h"
#include "ui_fmmsgwnd.h"
#include <QDebug>

FMMsgWnd::FMMsgWnd(QDialog *parent) :
    QDialog(parent),
    ui(new Ui::FMMsgWnd)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setWindowFlags(windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint);
}

FMMsgWnd::~FMMsgWnd()
{
    delete ui;
}

void FMMsgWnd::show(InfoType type, const QString &info)
{
    QString iconUrl;
    switch (type) {
    case T_Normal:
        iconUrl = "";
        break;
    case T_Success:
        iconUrl = ":/tip_ok.png";
        break;
    case T_Failure:
        iconUrl = ":/tip_error.png";
        break;
    case T_Warning:
        iconUrl = ":/tip_warning.png";
        break;
    case T_LoginSuccess:
        ui->label_msg->setText(QString::fromLocal8Bit("会员认证成功"));
        iconUrl = ":/tip_ok.png";
        break;
    default:
        iconUrl = "";
        break;
    }

    if(iconUrl != ""){
        QPixmap icon(iconUrl);
        ui->label_logo->setPixmap(icon);
    }

    ui->label_msg->setText(info);
    QDialog::exec();
}

void FMMsgWnd::FailureWnd(const QString &info, QDialog *parent)
{
    FMMsgWnd window(parent);
    if(parent != NULL)
        window.setGeometry(parent->geometry());
    window.show(FMMsgWnd::T_Failure, info);
}
void FMMsgWnd::WarningWnd(const QString &info, QDialog *parent)
{
    FMMsgWnd window(parent);
    window.setGeometry(parent->geometry());
    window.show(FMMsgWnd::T_Warning, info);
}
void FMMsgWnd::SuccessWnd(const QString &info, QDialog *parent)
{
    FMMsgWnd window(parent);
    window.setGeometry(parent->geometry());
    window.show(FMMsgWnd::T_Success, info);
}

void FMMsgWnd::LoginSuccess(const QString &account, const QString &name, const QString &birthday, QDialog *parent)
{
    FMMsgWnd window(parent);
    window.setGeometry(parent->geometry());
    QString info = QString::fromLocal8Bit("账号：%1\n姓名：%2\n生日：%3").arg(account).arg(name).arg(birthday);
    window.show(FMMsgWnd::T_LoginSuccess, info);
}

void FMMsgWnd::on_btn_confirm_clicked()
{
    this->close();
}
