﻿#include "tasklogin.h"
#include "fmviplogin.h"
#include "fmp_vip_settings.h"
#include "fmnetwork.h"
#include <QJsonDocument>
#include <QCryptographicHash>

TaskLogin::TaskLogin(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, session, parent)
{
}

QByteArray TaskLogin::doTask()
{
    FMP_DEBUG() << __FUNCTION__;
    //根据请求中是否有member_sign字段，判断是否是退货时发起的认证
    if(posReqJsonObj.contains("member_sign"))
    {
        //直接保存member_sign到_session中
        session()->addData("code", posReqJsonObj["member_sign"].toString());
        onLogin();
    }
    else
    {
        RunFunction(setWindow);
        RunFunction(showWindow);
    }
    RunFunction(packagePOSRsp);

    QJsonDocument json(posRspJsonObj);
    return json.toJson(QJsonDocument::Compact);
}

void TaskLogin::setWindow()
{
    _window = new FMVipLogin;

    connect(qobject_cast<FMVipLogin*>(_window), &FMVipLogin::login, this, &TaskLogin::onLogin);
    session()->addData("store_id", getPosJsonValue("store_id"));
    session()->addData("pos_id", getPosJsonValue("pos_id"));
    session()->addData("operator_id", getPosJsonValue("operator_id"));
    session()->addData("business_date", getPosJsonValue("business_date"));
}

void TaskLogin::showWindow()
{
    FMP_DEBUG() << __FUNCTION__;

    if(_window != nullptr) {
        _window->initWnd(session());
        int ret = _window->exec();
        if(ret == -1) {
            setError(FM_API_WINDOWCLOSE);
        }
    }
}

void TaskLogin::packageServerReq()
{
    serverReqJsonObj["appId"] = APP_ID;
    serverReqJsonObj["reqType"] = QString::number(FM_Login);
    serverReqJsonObj["stationId"] = getPosJsonValue("pos_id");
    serverReqJsonObj["storeId"] = getPosJsonValue("store_id");
    serverReqJsonObj["operatorId"] = getPosJsonValue("operator_id");
    serverReqJsonObj["partnerId"] = PARTNER_ID;
    serverReqJsonObj["code"] = session()->data("code").toString();
    serverReqJsonObj["t"] = QString::number(QDateTime::currentMSecsSinceEpoch());
}

bool TaskLogin::sendToServer(bool /*isShowMsg*/)
{
    FMP_DEBUG() << __FUNCTION__;
    packageServerReq();

    QJsonDocument json(serverReqJsonObj);
    QByteArray data = json.toJson(QJsonDocument::Compact);

    url = QString("%1?sign=%2").arg(FMPVipSettings::instance()->getServerUrl()).arg(sign());
    QByteArray rspData;

    FMNetwork net;
    net.send(url, data, rspData);

    // 网络错误
    if(net.error != FM_API_SUCCESS) {
        setError(net.error, net.errorMsg);
    } else {
        QJsonParseError jsonErr;
        QJsonDocument rspJson = QJsonDocument::fromJson(rspData, &jsonErr);

        // Json错误
        if(jsonErr.error != QJsonParseError::NoError) {
            setError(FM_API_BADJSON);
        } else {
            serverRspJsonObj = rspJson.object();
            // 服务器返回的错误
            if(serverRspJsonObj.contains("errcode")) {
                setError(FM_API_SERVERERROR, serverRspJsonObj["errcode"].toInt(), serverRspJsonObj["errmsg"].toString());
            }
        }
    }

    FMP_INFO() << "Server rsponse: " << serverRspJsonObj;

    if(_window != nullptr) {
        _window->setIsBusy(false);
    }

    bool isOk = (error() == FM_API_SUCCESS);

    return isOk;
}

void TaskLogin::packagePOSRsp()
{
    posRspJsonObj["statusCode"] = getServerJsonValue("statusCode").toInt();
    posRspJsonObj["msg"] = getServerJsonValue("msg").toString();
    posRspJsonObj["prompt"] = getServerJsonValue("prompt").toInt();
    posRspJsonObj["fm_open_id"] = getServerJsonValue("account").toString();
    posRspJsonObj["account"] = getServerJsonValue("memberNo").toString();
    posRspJsonObj["type_code"] = getServerJsonValue("typecode").toString();
    posRspJsonObj["type_name"] = getServerJsonValue("typename").toString();
    posRspJsonObj["amount"] = getServerJsonValue("amount").toInt();
    posRspJsonObj["score"] = getServerJsonValue("score").toInt();
    posRspJsonObj["name"] = getServerJsonValue("name").toString();
    posRspJsonObj["sex"] = getServerJsonValue("sex").toString();
    posRspJsonObj["birthday"] = getServerJsonValue("birthday").toString();
    posRspJsonObj["phone"] = getServerJsonValue("mobile").toString();
    posRspJsonObj["address"] = getServerJsonValue("address").toString();
    posRspJsonObj["email"] = getServerJsonValue("email").toString();
}

void TaskLogin::onLogin()
{
    bool isOk = sendToServer();
    if(!isOk) {
        if(_window != nullptr) {
            _window->close();
        }
        return;
    }

    // 认证失败
    if(getServerJsonValue("statusCode").toInt() != FM_API_SUCCESS) {
        QString info = serverRspJsonObj["msg"].toString();
        FMP_WARN() << "Login failed: " << info;
    }
    if(_window != nullptr)
    {
        _window->close();
    }
}