﻿#include "taskfinal.h"
#include "fmbackup.h"
#include "fmnetwork.h"
#include "fmp_logger_i.h"
#include "fmmsgwnd.h"
#include "fmp_vip_settings.h"
#include <QDateTime>
#include <QJsonDocument>
#include <QJsonArray>
#include <QCryptographicHash>

TaskFinal::TaskFinal(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, session, parent)
{
}

QByteArray TaskFinal::doTask()
{
    bool isOk = sendToServer();
    if(!isOk) {
        FMP_WARN() << QString("Task error %1: %2").arg(error()).arg(errorString());
        return QString(ErrorMsgJson).arg(error()).arg(errorString()).toLatin1();
    }
    packagePOSRsp();
    return QJsonDocument(posRspJsonObj).toJson(QJsonDocument::Compact);
}

void TaskFinal::packageServerReq()
{
    serverReqJsonObj["appId"] = APP_ID;
    serverReqJsonObj["stationId"] = getPosJsonValue("pos_id");
    serverReqJsonObj["storeId"] = getPosJsonValue("store_id");
    serverReqJsonObj["operatorId"] = getPosJsonValue("operator_id");
    serverReqJsonObj["partnerId"] = PARTNER_ID;
    serverReqJsonObj["businessDate"] = getPosJsonValue("business_date");
    //serverReqJsonObj["transId"] = getPosJsonValue("trans_id");
    serverReqJsonObj["memberTransId"] = "";
    QJsonObject transaction;
    transaction["account"] = getPosJsonValue("fm_open_id");
    transaction["totalAmount"] = getPosJsonValue("order_amount");
    transaction["payAmount"] = getPosJsonValue("paid_amount");
    
    // 产品列表
    QJsonArray products;
    foreach(auto p , getPosJsonValue("products").toArray())
    {
        QJsonObject product;
        product["consumeNum"] = p.toObject()["consume_num"].toString().toDouble();
        product["price"] = p.toObject()["price"];
        product["productId"] = p.toObject()["pid"];
        
        products.append(product);
    }
    transaction["products"] = products;
    
    QJsonArray payList;
    foreach(auto p, getPosJsonValue(PosProps.Pay_ids).toArray())
    {
        QJsonObject pay;
        pay["amount"] = p.toObject()["pay_amount"].toInt();
        pay["thirdPayTransId"] = p.toObject()["thirdPayTransId"].toString();
        pay["code"] = p.toObject()["code"].toString();
        pay["transId"] = getPosJsonValue("trans_id").toString();
        pay["payTransId"] = p.toObject()["pay_transId"].toString();
        QString typeModeFlag = p.toObject()["pay_id"].toString();
        
        if(typeModeFlag == "00")
        {
            //现金支付
            pay["typeModeFlag"] = 20005;
        }
        else if(typeModeFlag == "000")
        {
            //非码会员支付
            if(p.toObject()["code"].toString().isEmpty())
            {
                //券码为空，是 会员储值金支付
                pay["typeModeFlag"] = 20001;
            }
            else
            {
                //否则，是代金券/商品券支付（统一转为代金券）
                pay["typeModeFlag"] = 20003;
            }
        }
        else if(typeModeFlag == "7")
        {
            //支付宝钱包
            pay["typeModeFlag"] = 10001; 
        }
        else if(typeModeFlag == "9")
        {
            //微信钱包
            pay["typeModeFlag"] = 10004; //
        }
        else if(typeModeFlag == "2")
        {
            //银行卡
            pay["typeModeFlag"] = 10011;
        }
        else if(typeModeFlag == "8")
        {
            //翼支付
            pay["typeModeFlag"] = 10010;
        }
        else
        {
            pay["typeModeFlag"] = typeModeFlag.toInt();
            FMP_ERROR() << QStringLiteral("未知的支付类型: ") << typeModeFlag;
        }
        
//        if(typeModeFlag == "20002")
//        {
//            //积分支付
//            pay["typeModeFlag"] = 20002;
//        }
        
        payList.append(pay);
    }
    transaction["payList"] = payList;
    serverReqJsonObj["transaction"] = transaction;
    serverReqJsonObj["t"] = QString::number(QDateTime::currentMSecsSinceEpoch());
    
    int finalType = getPosJsonValue("settlement_type").toInt();
    if(finalType == 0) //支付结算
    {
        serverReqJsonObj["transId"] = getPosJsonValue("trans_id");
        serverReqJsonObj["reqType"] = QString::number(FM_Final);
    }
    else if(finalType == 1) //退款结算
    {
        serverReqJsonObj["transId"] = getPosJsonValue("refund_trans_id");
        serverReqJsonObj["reqType"] = QString::number(1010);
    }
}

bool TaskFinal::sendToServer(bool /*isShowMsg*/)
{
    FMP_DEBUG() << __FUNCTION__;
    packageServerReq();

    QJsonDocument json(serverReqJsonObj);
    QByteArray data = json.toJson(QJsonDocument::Compact);

    url = QString("%1?sign=%2").arg(FMPVipSettings::instance()->getServerUrl()).arg(sign());
    QByteArray rspData;

    FMNetwork net;
    net.send(url, data, rspData);

    // 网络错误
    if(net.error != FM_API_SUCCESS) {
        setError(net.error, net.errorMsg);
    } else {
        QJsonParseError jsonErr;
        QJsonDocument rspJson = QJsonDocument::fromJson(rspData, &jsonErr);
        qDebug() << rspJson;

        // Json错误
        if(jsonErr.error != QJsonParseError::NoError) {
            setError(FM_API_BADJSON);
        } else {
            serverRspJsonObj = rspJson.object();
            // 服务器返回的错误
            if(serverRspJsonObj.contains("errcode")) {
                setError(FM_API_SERVERERROR, serverRspJsonObj["errcode"].toInt(), serverRspJsonObj["errmsg"].toString());
            }
        }
    }

    FMP_INFO() << "Server rsponse: " << serverRspJsonObj;    
    
    // 备份
    if(error() == FM_API_NETWORERROR) {

        if(searchJsonValue(serverReqJsonObj,ServerProps(PosProps.CodeAmount)).toInt() == 0 &&
           searchJsonValue(serverReqJsonObj,ServerProps(PosProps.ScoreAmount)).toInt() == 0 &&
           searchJsonValue(serverReqJsonObj,ServerProps(PosProps.Coupons)).toArray().isEmpty()) {
            QString fm_id = backup();
            if(!fm_id.isEmpty()){
                setError(FM_API_SUCCESS);
                serverRspJsonObj[ServerProps(PosProps.StatusCode)] = FM_API_SUCCESS;
                serverRspJsonObj[ServerProps(PosProps.Msg)] = QString::fromLocal8Bit("结算成功");
                serverRspJsonObj[ServerProps(PosProps.Fm_id)] = fm_id;
                serverRspJsonObj[ServerProps(PosProps.Prompt)] = 1;
                serverRspJsonObj[ServerProps(PosProps.Print1)] = "";
                serverRspJsonObj[ServerProps(PosProps.Print2)] = "";
            }
        }
    }
    bool isOk = (error() == FM_API_SUCCESS);

    return isOk;
}

void TaskFinal::packagePOSRsp()
{
    posRspJsonObj[PosProps.StatusCode] = getServerJsonValue(PosProps.StatusCode);
    posRspJsonObj[PosProps.Msg] = getServerJsonValue(PosProps.Msg);
    posRspJsonObj[PosProps.Prompt] = 1;
}

QString TaskFinal::backup()
{
    int newId = FMBackup::instance()->insertNewRow();
    QString uuid = QString("E%1%2%3%4")
            .arg(getPosJsonValue(PosProps.StoreId).toString())
            .arg(getPosJsonValue(PosProps.PosId).toString().toInt(), 2, 10, QChar('0'))
            .arg(QDateTime::currentDateTime().toString("yyMMdd"))
            .arg(newId, 5, 10, QChar('0'));
    QJsonDocument json(serverReqJsonObj);
    bool isOk = FMBackup::instance()->updateReqData(newId, this->url, json.toJson(QJsonDocument::Compact));
    if(isOk && uuid.length()==20) {
        return uuid;
    }
    return "";
}