﻿#ifndef SESSION_H
#define SESSION_H

#include <QVariant>
#include <QVector>
#include "global.h"

//代金券所适用的商品的信息
struct ApplyProduct
{
    int price; //商品价格
    int coupon_discount_amount;//抵消额
    QString pid; //商品id
    int consume_num; //商品数量
};
Q_DECLARE_METATYPE(ApplyProduct)

// 代金券结构体
struct Coupon
{
    Coupon() {
        code = "";
        disAmount = 0.0;
        desc = "";
        typeModeFlag = -1;
        limit_amount = 0;
        dis_price = 0;
        compatible_flag = 0;
    }
    Coupon(const Coupon& C) {
        code = C.code;
        disAmount = C.disAmount;
        desc = C.desc;
        typeModeFlag = C.typeModeFlag;
        limit_amount = C.limit_amount;
        dis_price = C.dis_price;
        compatible_flag = C.compatible_flag;
    }
    Coupon(const QString &c, const double amount, const QString &d) {
        code = c;
        disAmount = amount;
        desc = d;
        typeModeFlag = -1;
        limit_amount = 0;
        dis_price = 0;
        compatible_flag = 0;
    }

    QString code;
    double disAmount;
    QString desc;
    int typeModeFlag; //代金券 or 商品券
    QVector<ApplyProduct> applyProducts; //该券适用的商品
    int limit_amount; //满额条件
    int dis_price; //该券应用到商品后，实际抵扣金额
    int compatible_flag; //是否可叠加
};
Q_DECLARE_METATYPE(Coupon)      // 使Coupon类型可以和QVariant类型互相转换

class Session
{
public:
    Session();
    Session(const Session& other) {
        this->_sessionDataMap = other.sessionDataMap();
    }

    ~Session();

    Session &operator =(const Session& other) {
        this->_sessionDataMap = other.sessionDataMap();
        return *this;
    }

    QVariant data(const QString key) const;

    void addData(const QString key, const QVariant value);
    void addData(const QString key, const QMap<QString, Coupon> couponMap);
    QMap<QString, Coupon> getCouponMap(const QString key);

    QMap<QString, QVariant> sessionDataMap() const { return this->_sessionDataMap;}
    void setSessionDataMap(const QMap<QString, QVariant> &dataMap) {this->_sessionDataMap = dataMap;}
private:
    QMap<QString, QVariant>  _sessionDataMap;
};

#endif // SESSION_H
