﻿#ifndef FMTASK_H
#define FMTASK_H
#include "fmvipwnd.h"
#include "fmmsgwnd.h"
#include "session.h"
#include <QObject>
#include <QJsonObject>
#include <QJsonArray>
#include <QDebug>

#define RunFunction(function)   do {    \
        function##();                   \
        if(error() != FM_API_SUCCESS) { \
            FMP_WARN() << QString("Task error %1: %2").arg(error()).arg(errorString());   \
            QString msg = ErrorMsgJson;\
            msg = msg.arg(error());\
            switch(error())\
            {\
            case FM_API_ERROR: \
                 msg = msg.arg(QStringLiteral("失败"));\
                 break;\
            case FM_API_TIMEOUT:\
                 msg = msg.arg(QStringLiteral("网络超时"));\
                 break;\
            case FM_API_BADJSON:\
                 msg = msg.arg(QStringLiteral("无效的JSON数据"));\
                 break;\
            case FM_API_NETWORERROR:\
                 msg = msg.arg(QStringLiteral("网络错误"));\
                 break;\
            case FM_API_SERVERERROR:\
                 msg = msg.arg(QStringLiteral("服务器错误"));\
                 break;\
            case FM_API_WINDOWCLOSE:\
                 msg = msg.arg(QStringLiteral("窗口关闭"));\
                 break;\
            }\
            return msg.toUtf8();    \
        }                               \
} while(0);

class FMTask : public QObject
{
    Q_OBJECT
public:
    explicit FMTask(QJsonObject &jsonObj, Session *session = 0, QObject *parent = 0);
    ~FMTask();

    Session* session() const {return _session;}

    QJsonValue searchJsonValue(QJsonObject &searchJson, QString searchKey);
    QJsonValue searchJsonObject(QJsonObject& searchJson, QString searchKey);
    QJsonValue searchJsonArray(QJsonArray& searchJson, QString searchKey);
    QJsonValue getServerJsonValue(const QString prop);
    QJsonValue getPosJsonValue(const QString prop);

protected:
    QJsonObject posReqJsonObj;
    QJsonObject posRspJsonObj;
    QJsonObject serverReqJsonObj;
    QJsonObject serverRspJsonObj;
    FMVipWnd    *_window;
    Session     *_session;
    QString     url;
    
public:
    QString sign() const;

 /**
 * @brief FMError
 * define error.
 */
typedef int FMError;
public:
    FMError error() const {return _error;}
    void setError(const FMError error)
    { _error = error; _errorMsg = "";}
    void setError(const FMError error, const QString errorMsg)
    { _error = error; _errorMsg = errorMsg;}
    void setError(const FMError error, const int errorCode, const QString errorMsg)
    { _error = error; _errorMsg = QString("[%1]%2").arg(errorCode).arg(errorMsg);}
    QString errorString() {
        if(fm_error.find(_error) == fm_error.end()) {
            return "Undefine Error";
        } else {
            if(_errorMsg != "")
                return _errorMsg;
            return fm_error.at(_error);
        }
    }
private:
    FMError _error;
    QString _errorMsg;
};

#endif // FMTASK_H
