﻿#include "fmtask.h"
#include "fmnetwork.h"
#include <QDateTime>
#include <QSettings>
#include <QJsonDocument>
#include <QJsonParseError>
#include <QCryptographicHash>
#include "fmp_vip_settings.h"

FMTask::FMTask(QJsonObject &jsonObj, Session *session, QObject *parent) :
    QObject(parent),
    posReqJsonObj(jsonObj),
    _window(nullptr),
    _error(FM_API_SUCCESS),
    _errorMsg(""),
    _session(session)
{
}

FMTask::~FMTask()
{
    del_p(_window);
}

QJsonValue FMTask::searchJsonObject(QJsonObject& searchJson, QString searchKey)
{
    QJsonValue value;
    if(searchJson.contains(searchKey))
    {
        return searchJson[searchKey];
    }
    else
    {
        foreach(QString key, searchJson.keys())
        {
            if(searchJson[key].isObject())
            {
                QJsonObject ob = searchJson[key].toObject();
                value = searchJsonObject(ob, searchKey);
            }
            else if(searchJson[key].isArray())
            {
                QJsonArray arr = searchJson[key].toArray();
                value = searchJsonArray(arr, searchKey);
            }
        }
    }
    return value;
}

QJsonValue FMTask::searchJsonArray(QJsonArray& searchJson, QString searchKey)
{
    QJsonValue value;
    for(int i = 0; i < searchJson.size(); i++)
    {
        if(searchJson[i].isObject())
        {
            QJsonObject ob = searchJson[i].toObject();
            value = searchJsonObject(ob, searchKey);
        }
        else if(searchJson[i].isArray())
        {
            QJsonArray arr = searchJson[i].toArray();
            value = searchJsonArray(arr, searchKey);
        }
    }
    return value;
}

QJsonValue FMTask::searchJsonValue(QJsonObject &searchJson, QString searchKey)
{
    if(searchJson.contains(searchKey)) {
        return searchJson[searchKey];
    } else {
        qDebug() << searchJson.keys();
        foreach(QString key , searchJson.keys()) {
            if(searchJson[key].isObject()) {
                QJsonObject ob = searchJson[key].toObject();
                QJsonValue value = searchJsonValue(ob, searchKey);
                if(!value.isNull()){
                    return value;
                }
            }
        }
    }
    return QJsonValue();
}

QJsonValue FMTask::getServerJsonValue(const QString prop)
{
    return searchJsonObject(serverRspJsonObj, prop);
}

QJsonValue FMTask::getPosJsonValue(const QString prop)
{
    return searchJsonObject(posReqJsonObj, prop);
}

QString FMTask::sign() const
{
    FMP_DEBUG() << __FUNCTION__;
    // 解析JSON插入MAP中按字典排序
    QMap<QString, QString> mapData;

    for(int i=0; i<sizeof(SignProps)/sizeof(SignProps[0]); ++i) {
        QString word = SignProps[i];
        if(serverReqJsonObj[word].isDouble()) {
            mapData[word] = QString::number(serverReqJsonObj[word].toDouble());
        } else {
            mapData[word] = serverReqJsonObj[word].toString();
        }
    }

    if (serverRspJsonObj[ServerProps(PosProps.Fm_cmd)].toInt() == FM_Fund) {
        mapData[ServerProps(PosProps.TransId)] = serverReqJsonObj[ServerProps(PosProps.TransId)].toString();
    }

    // 使用URL键值对的格式拼接
    QString sb = "";
    foreach(QString key , mapData.keys())
    {
        sb += (key + "=" + mapData.value(key) + "&");
    }
    sb.remove(sb.length() - 1, 1);      // 去掉最后一个&

    sb.append(KEY_CODE);

    QByteArray bt;
    bt.append(sb);

    FMP_INFO() << "Sign String: " << bt;

    QByteArray md5Bt = QCryptographicHash::hash(bt, QCryptographicHash::Md5);
    return md5Bt.toHex();
}
