﻿#include <QMenu>
#include <QAction>
#include <QTimer>
#include <QJsonParseError>
#include "fmp_vip_settings.h"
#include <winsock2.h>
#include "fmvipdispatcher.h"
#include "fmtask.h"
#include "taskfactory.h"
#include "fmp_vip_server.h"
#include "tasklogin.h"
#include "taskpay.h"
#include "taskfinal.h"

FMVipDispatcher::FMVipDispatcher(QObject *parent) :
    QObject(parent)
{
}

FMVipDispatcher::~FMVipDispatcher()
{
}

void FMVipDispatcher::doTask(const QByteArray &reqData, QByteArray &rspData)
{
    FMP_INFO() << "Recv POS reqData: " << reqData;
    Session session;
    
    QJsonParseError error;
    QJsonDocument doc = QJsonDocument::fromJson(reqData, &error);
    qDebug() << error.errorString();
    QJsonObject jsonObj = doc.object();
    FM_TYPE type = (FM_TYPE)jsonObj["fm_cmd"].toInt();
    
    switch (type) {
    case FM_Login: {
        TaskLogin taskLogin(jsonObj, &session);
        rspData = taskLogin.doTask();
        break;
    }
    case FM_Pay: {
        TaskPay taskPay(jsonObj, &session);
        rspData = taskPay.doTask();
        break;
    }
    case FM_Final: {
        TaskFinal taskFinal(jsonObj, &session);
        rspData = taskFinal.doTask();
        break;
    }
    default:
        rspData = QString::fromLocal8Bit("{\"msg:\":\"未知的请求类型\"}").toUtf8();
        break;
    }

    FMP_INFO() << "Send to pos: " << rspData;
}