﻿#include "fmp_vip_server.h"
#include "fmvipdispatcher.h"
#include "fmp_vip_settings.h"
#include <QTcpSocket>
#include <QDebug>

FMPVipServer *FMPVipServer::instance()
{
    static FMPVipServer server;
    return &server;
}

FMPVipServer::FMPVipServer() :
    QTcpServer(),
    socket(nullptr),
    dispatcher(new FMVipDispatcher(this))
{
    Listen(23770);
    connect(this, &QTcpServer::newConnection, this, &FMPVipServer::onNewConnection);
}

void FMPVipServer::Listen(quint16 port)
{
    if(!this->listen(QHostAddress::Any, port)) {
        FMP_ERROR() << "Listen error: " << this->errorString();
    }
}

void FMPVipServer::Write(const QByteArray &data)
{
    if(!socket || socket->write(data) == -1) {
        FMP_ERROR() << "Write error: " << (socket ? socket->errorString() : "connection closed.");
    }
}

void FMPVipServer::onNewConnection()
{
    socket = nextPendingConnection();

    connect(socket, &QTcpSocket::disconnected, this, &FMPVipServer::onDisconnected);
    connect(socket, &QTcpSocket::readyRead, this, &FMPVipServer::onReadyRead);
}

void FMPVipServer::onDisconnected()
{
    FMP_DEBUG() << "Socket disconnected.";
    socket->close();
}

void FMPVipServer::onReadyRead()
{
    QByteArray recvData = socket->readAll();
    FMSOCKEHEADER header = {0};
    memcpy(&header, recvData.data(), sizeof(FMSOCKEHEADER));
    if(header.flag != FMSOCKFLAG) {
        FMP_WARN() << "Incompatible protocol.";
        return;
    }

    QByteArray rspData;
    dispatcher->doTask(recvData.mid(sizeof(FMSOCKEHEADER)), rspData);

    Write(rspData);
    
    socket->waitForBytesWritten();
    socket->close();
    socket->deleteLater();
    socket = nullptr;
}
