﻿#ifndef FMP_MANAGER_EVENT_HANDLERS_H
#define FMP_MANAGER_EVENT_HANDLERS_H

#include <QObject>
#include <service/event/ctkEventConstants.h>
#include <service/event/ctkEventHandler.h>

class FMPVip;


class FMPVipEventHandler : public ctkEventHandler
{
public:
    explicit            FMPVipEventHandler(const QString &topic, FMPVip *vip) : _vip(vip), _topic(topic) {}

protected:
    FMPVip*             _vip;
    const QString       _topic;
};

/**
 * 升级事件处理类
 * @brief The FMPUpgradeEventHandler class
 */
class FMPStartEventHandler : public QObject, public FMPVipEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)
public:
    explicit            FMPStartEventHandler(ctkPluginContext *ctx, FMPVip *vip);
    void                handleEvent(const ctkEvent &event);

private:
    ctkPluginContext*   _ctx;
};

#endif // FMP_MANAGER_EVENT_HANDLERS_H
