﻿#include "resend.h"
#include "fmbackup.h"
#include "fmnetwork.h"
#include "fmp_vip_settings.h"
#include <QSqlQuery>
#include <QSqlRecord>
#include <QNetworkReply>
#include <QDebug>

ReSend::ReSend()
{
}

ReSend::~ReSend()
{
}

void ReSend::trySend()
{
    QSqlRecord record;
    QSqlQuery reqDataQuery = FMBackup::instance()->reqDataQuery();
    while(reqDataQuery.next())
    {
        record = reqDataQuery.record();
        int id = record.value(ID).toInt();
        QString url = record.value(URL).toString();
        QByteArray data = record.value(DATA).toByteArray();
        QByteArray rspData;

        FMNetwork net;
        net.send(url, data, rspData);

        // 如果发送失败则不再继续发送
        if(net.error != 1) {
            break;
        } else{
            FMBackup::instance()->removeReqData(id);
            FMP_INFO() << QString::fromLocal8Bit("重发响应成功：")<< rspData;
        }
    }
}

void ReSend::run()
{
    while(true)
    {
        trySend();
        QThread::sleep(5);
    }
}
