﻿#include "fmviplogin.h"
#include "ui_fmviplogin.h"
#include "fmvippanel.h"
#include <QFile>
#include <QMutex>
#include "fmloading.h"

FMVipLogin::FMVipLogin(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipLogin)
{
    ui->setupUi(this);
}

FMVipLogin::~FMVipLogin()
{
    delete ui;
}

void FMVipLogin::initWnd(Session *session)
{
    this->_session = session;

    QString placeText = QString::fromLocal8Bit("输入手机号/会员码/支付码");
//    if(session->data(PosProps.FM_Type).toInt() == FM_Pay) {
//        placeText = QString::fromLocal8Bit("输入支付码");
//    } else {
//        placeText = QString::fromLocal8Bit("输入手机号/会员码/支付码");
//    }
    ui->store_label->setText(session->data(PosProps.StoreId).toString());
    ui->pos_label->setText(session->data(PosProps.PosId).toString());
    ui->operator_label->setText(session->data(PosProps.OperatorId).toString());
    ui->bd_label->setText(session->data(PosProps.BussinessDate).toString());
    ui->login_edit->setPlaceholderText(placeText);
}

QString FMVipLogin::getVersionInfo()
{
    QByteArray versionInfo;
    QFile versionFile(qApp->applicationDirPath() + "/version.dat");
    bool isOk = versionFile.open(QIODevice::ReadOnly);
    if(isOk) {
        versionInfo = versionFile.readAll();
    } else {
        versionInfo = QString::fromLocal8Bit("未知").toUtf8();
    }
    versionFile.close();
    return versionInfo;
}

void FMVipLogin::on_login_btn_clicked()
{
    QString id = ui->login_edit->text();

    _session->addData("code", id);

    this->setEnabled(false);

    setIsBusy(true);

    emit login();
}

void FMVipLogin::resetWnd()
{
    this->setEnabled(true);
    ui->login_edit->clear();
    ui->login_edit->setFocus();
}
