﻿#include "fmvipfund.h"
//#include "fmvipforward.h"
#include "ui_fmvipfund.h"

FMVipFund::FMVipFund(QDialog *parent) :
    FMVipWnd(parent),
    ui(new Ui::FMVipFund)
{
    ui->setupUi(this);
}

FMVipFund::~FMVipFund()
{
    delete ui;
}

void FMVipFund::initWnd(Session *session)
{
    _session = session;

    QString operator_id = session->data(PosProps.OperatorId).toString();
    QString business_date = session->data(PosProps.BussinessDate).toString();
    QString account = session->data(PosProps.Fm_open_id).toString();
    QString name = session->data(PosProps.Name).toString();

    double amount = session->data(PosProps.Amount).toInt() / 100.0;
    double charge_amount = session->data(PosProps.ChargeAmount).toInt() / 100.0;

    QString show_amount_str = QString::number(amount, 'f', 2);
    QString show_charge_amount_str = QString::number(charge_amount, 'f', 2);

    ui->store_label->setText(session->data(PosProps.StoreId).toString());
    ui->pos_label->setText(session->data(PosProps.PosId).toString());
    ui->operator_label->setText(operator_id);
    ui->bd_label->setText(business_date);
    ui->id_label->setText(account);
    ui->balance_label->setText(show_amount_str);
    ui->amount_edit->setText(show_charge_amount_str);
    ui->name_label->setText(name);

    ui->fund_btn->setFocus();
}

void FMVipFund::on_fund_btn_clicked()
{
    int fundAmount = ui->amount_edit->text().toDouble() * 100;
    _session->addData(PosProps.ChargeAmount, fundAmount);

    this->setEnabled(false);

    setIsBusy(true);

    emit fund();
}
