#ifndef TASKLOGIN_H
#define TASKLOGIN_H
#include "fmtask.h"
#include <QObject>
#include <QJsonObject>

class TaskLogin : public QObject
{
    Q_OBJECT
public:
    explicit TaskLogin(QJsonObject &jsonObj, Session* session = 0, QObject* parent=0);
    ~TaskLogin();
    
    QByteArray doTask();
    Session* session() const {return _session;}
    
    QJsonValue searchJsonValue(QJsonObject &searchJson, QString searchKey);
    QJsonValue getServerJsonValue(const QString prop);
    QJsonValue getPosJsonValue(const QString prop);

private:
    void setWindow();
    void showWindow();
    void packageServerReq();
    bool sendToServer(bool isShowMsg = true);
    void packagePOSRsp();

public slots:
    void onLogin();
    
private:
    QString sign() const;
    
private:
    QJsonObject posReqJsonObj; //pos发来的请求数据
    QJsonObject posRspJsonObj; //返回给pos的数据
    QJsonObject serverReqJsonObj; //发送给server端的请求数据
    QJsonObject serverRspJsonObj; //server返回的数据
    FMVipWnd    *_window;
    Session     *_session;
    QString     url; //server url
    
    /**
    * @brief FMError
    * define error.
    */
    typedef int FMError;
public:
    FMError error() const {return _error;}
    void setError(const FMError error)
    { _error = error; _errorMsg = "";}
    void setError(const FMError error, const QString errorMsg)
    { _error = error; _errorMsg = errorMsg;}
    void setError(const FMError error, const int errorCode, const QString errorMsg)
    { _error = error; _errorMsg = QString("[%1]%2").arg(errorCode).arg(errorMsg);}
    QString errorString() {
        if(fm_error.find(_error) == fm_error.end()) {
            return "Undefine Error";
        } else {
            if(_errorMsg != "")
                return _errorMsg;
            return fm_error.at(_error);
        }
    }
private:
    FMError _error;
    QString _errorMsg;
};

#endif // TASKLOGIN_H