#ifndef TASKFINAL_H
#define TASKFINAL_H
#include <QObject>
#include <QJsonObject>
#include "session.h"

class TaskFinal : public QObject
{
    Q_OBJECT
public:
    explicit TaskFinal(QJsonObject &jsonObj, Session *session = 0, QObject *parent = 0);
    
    QByteArray doTask();
    void setFM_Type(const FM_TYPE fmType) {_FM_Type = fmType;}
    FM_TYPE FM_Type() const { return _FM_Type;}
    Session* session() const {return _session;}
    
    void packageServerReq();
    bool sendToServer(bool isShowMsg = true);
    void packagePOSRsp();
    
    QJsonValue searchJsonValue(QJsonObject &searchJson, QString searchKey);
    QJsonValue getServerJsonValue(const QString prop);
    QJsonValue getPosJsonValue(const QString prop);
private:
    QString backup();
    QString sign() const;
    
    QJsonObject posReqJsonObj;
    QJsonObject posRspJsonObj;
    QJsonObject serverReqJsonObj;
    QJsonObject serverRspJsonObj;
    Session     *_session;
    FM_TYPE     _FM_Type;
    QString     url;
    
    /**
    * @brief FMError
    * define error.
    */
    typedef int FMError;
public:
    FMError error() const {return _error;}
    void setError(const FMError error)
    { _error = error; _errorMsg = "";}
    void setError(const FMError error, const QString errorMsg)
    { _error = error; _errorMsg = errorMsg;}
    void setError(const FMError error, const int errorCode, const QString errorMsg)
    { _error = error; _errorMsg = QString("[%1]%2").arg(errorCode).arg(errorMsg);}
    QString errorString() {
        if(fm_error.find(_error) == fm_error.end()) {
            return "Undefine Error";
        } else {
            if(_errorMsg != "")
                return _errorMsg;
            return fm_error.at(_error);
        }
    }
private:
    FMError _error;
    QString _errorMsg;
};

#endif // TASKFINAL_H
