#ifndef TASKCOUPON_H
#define TASKCOUPON_H

#include <QObject>
#include <QJsonObject>
#include "session.h"

//根据订单，查询可用的优惠券
class TaskCoupon : public QObject
{
    Q_OBJECT
public:
    explicit TaskCoupon(QJsonObject &jsonObj, Session *session = 0, QObject *parent = 0);

    QByteArray doTask();

    Session* session() const {return _session;}

    QJsonValue searchJsonValue(QJsonObject &searchJson, QString searchKey);
    QJsonValue getServerJsonValue(const QString prop);
    QJsonValue getPosJsonValue(const QString prop);

protected:
    void packageServerReq();
    bool sendToServer(bool isShowMsg = true);
    void packagePOSRsp();

protected:
    QJsonObject posReqJsonObj;
    QJsonObject posRspJsonObj;
    QJsonObject serverReqJsonObj;
    QJsonObject serverRspJsonObj;
    Session     *_session;
    QString     url;

private:
    QString sign() const;

 /**
 * @brief FMError
 * define error.
 */
typedef int FMError;
public:
    FMError error() const {return _error;}
    void setError(const FMError error)
    { _error = error; _errorMsg = "";}
    void setError(const FMError error, const QString errorMsg)
    { _error = error; _errorMsg = errorMsg;}
    void setError(const FMError error, const int errorCode, const QString errorMsg)
    { _error = error; _errorMsg = QString("[%1]%2").arg(errorCode).arg(errorMsg);}
    QString errorString() {
        if(fm_error.find(_error) == fm_error.end()) {
            return "Undefine Error";
        } else {
            if(_errorMsg != "")
                return _errorMsg;
            return fm_error.at(_error);
        }
    }
private:
    FMError _error;
    QString _errorMsg;
};

#endif // TASKCOUPON_H