﻿#include "session.h"
#include <QDebug>

Session::Session()
{

}

Session::~Session()
{
}

QVariant Session::data(const QString key) const
{
    QVariant value;
    if (_sessionDataMap.contains(key)) {
        value = _sessionDataMap[key];
    }
    return value;
}

void Session::addData(const QString key, const QVariant value)
{
    _sessionDataMap[key] = value;
}

void Session::addData(const QString key, const QMap<QString, Coupon> couponMap)
{
    QVariantMap v_couponMap;
    foreach(const Coupon coupon , couponMap) {
        QVariant v;
        v.setValue(coupon);
        v_couponMap[coupon.code] = v;
    }
    addData(key, v_couponMap);
}

QMap<QString, Coupon> Session::getCouponMap(const QString key)
{
    QVariantMap v_couponMap = data(key).toMap();
    QMap<QString, Coupon> couponMap;
    foreach(const QVariant v_coupon , v_couponMap) {
        Coupon coupon = v_coupon.value<Coupon>();
        couponMap[coupon.code] = coupon;
    }
    return couponMap;
}
