﻿#ifndef GLOBAL_H
#define GLOBAL_H
#include <QObject>
#include <QApplication>
#include <string>
/**/
// 商家信息
#define APP_ID			 "T012"
#define KEY_CODE		 "fbb36c88-999d-4836-a5ed-8e8855061ba6"
#define PARTNER_ID		 "6ac642f1-59f8-4e6f-a07a-bc8d581025d9"

// 请求类型的枚举值
enum FM_TYPE {
    FM_Login = 1001,
	FM_Pay = 1003,
	FM_Order_Refund,
    FM_Charge_Refund,
	FM_Final = 1007,
    FM_Coupon = 1009,
    FM_Fund,
    FM_Order_Revoke,
    FM_QR_Pay = 10031,
    FM_QR_Refund = 10041
};

// JSON数据各字段名称
#ifndef POSPROPS
#define POSPROPS
struct PP{
    PP()
    {
            AppId            = "appId";
            PartnerId        = "partnerId";
            T                = "t";
            StoreId          = "store_id";
            PosId            = "pos_id";
            OperatorId       = "operator_id";
            BussinessDate    = "business_date";
            Fm_cmd           = "fm_cmd";
            FM_Type          = "FM_Type";
            TransId          = "trans_id";
            Member_sign      = "member_sign";
			Account          = "account";
			Type_code        = "type_code";
			Type_name        = "type_name";

            Name             = "name";
			Sex              = "sex";
            Birthday         = "birthday";
            Amount           = "amount";
            Phone            = "phone";
            Fm_open_id       = "fm_open_id";
            CanPay           = "CanPay";
			Address          = "address";
			Email            = "email";

            Score            = "score";

            StatusCode       = "statusCode";
            Msg              = "msg";
            Prompt           = "prompt";

            Coupon           = "coupon";         // 优惠券查询时的优惠券号

            CodeAmount       = "codeAmount";
            ScoreAmount      = "scoreAmount";
            IsUseScore       = "isUseScore";
            Coupons          = "coupons";
            Transaction      = "transaction";
            OrderAmount      = "order_amount";
			PaidAmount       = "paid_amount";
            NeedAmount       = "need_amount";
            StandardAmount   = "standard_amount";
            Fm_id            = "fm_id";
			Settlement       = "settlement";
			Fm_transId       = "fm_transId";
			Pro_amount       = "pro_amount";
			Pay_amount       = "pay_amount";

            Pay_ids          = "pay_ids";
            Pay_id           = "pay_id";
            Pay_str          = "pay_str";
            Paid_total_amount= "paid_total_amount";
            Pay_transId      = "pay_transId";
            CouponList       = "couponList";     // 代金券列表
            Coupon_code      = "code";           // 优惠券 / 代金券编码
            Coupon_disAmount = "disAmount";      // 代金券抵扣金额
            Coupon_desc      = "desc";           // 代金券描述
            CouponMap        = "payCouponMap";   // 代金券map

            Products         = "products";
            ConsumeNum       = "consume_num";
            Price            = "price";
            ProductId        = "pid";

            Print1           = "print1";
            Print2           = "print2";

            ChargeAmount     = "charge_amount";
            CashAmount       = "cashAmount";
            Print            = "print";
            ThirdAmount      = "thirdAmount";
    }

    QString AppId             ;
    QString PartnerId         ;
    QString T                 ;
    QString StoreId           ;
    QString PosId             ;
    QString OperatorId        ;
    QString BussinessDate     ;
    QString Fm_cmd            ;
    QString FM_Type           ;
    QString TransId           ;
    QString Member_sign       ;
	QString Account			  ;
	QString Type_code         ;
	QString Type_name         ;

    QString Name              ;
	QString Sex               ;
    QString Birthday          ;
    QString Amount            ;
    QString Phone             ;
    QString Fm_open_id        ;
    QString CanPay            ;
	QString Address           ;
	QString Email             ;

    QString Score             ;

    QString StatusCode        ;
    QString Msg               ;
    QString Prompt            ;

    QString Coupon            ;

    // 支付
    QString CodeAmount        ;
    QString ScoreAmount       ;
    QString IsUseScore        ;
    QString Coupons           ;
    QString Transaction       ;
    QString OrderAmount       ;
    QString NeedAmount        ;
	QString PaidAmount        ;
    QString StandardAmount    ;
    QString Fm_id             ;
	QString Settlement        ;
	QString Fm_transId        ;
	QString Pro_amount        ;
	QString Pay_amount        ;
	
	
    // 支付方式
    QString Pay_ids           ;
    QString Pay_id            ;
    QString Pay_str           ;
    QString Paid_total_amount ;
    QString Pay_transId       ;
    QString CouponList        ;
    QString Coupon_code       ;
    QString Coupon_disAmount  ;
    QString Coupon_desc       ;
    QString CouponMap         ;
    // 产品
    QString Products          ;
    QString ConsumeNum        ;
    QString Price             ;
    QString ProductId         ;

    QString Print1            ;
    QString Print2            ;

    // 充值
    QString ChargeAmount      ;
    QString CashAmount        ;
    QString Print             ;
    QString ThirdAmount       ;
};

const static PP PosProps;
#endif

// Pos端属性与服务端属性映射配置
#ifndef FMPROPSMAP
#define FMPROPSMAP
typedef std::map<QString, QString> PropsMap;
const PropsMap::value_type PropsMapPairs[] =
{
    PropsMap::value_type(PosProps.Fm_cmd,       "reqType"),
    PropsMap::value_type(PosProps.Member_sign,  "code"),
    PropsMap::value_type(PosProps.StoreId,      "storeId"),
    PropsMap::value_type(PosProps.PosId,        "stationId"),
    PropsMap::value_type(PosProps.OperatorId,   "operatorId"),
    PropsMap::value_type(PosProps.Phone,       "mobile"),
    PropsMap::value_type(PosProps.TransId,      "transId"),
    PropsMap::value_type(PosProps.Coupon,       "couponCode"),
    PropsMap::value_type(PosProps.BussinessDate,"businessDate"),
	PropsMap::value_type(PosProps.Fm_open_id, "account"),
	PropsMap::value_type(PosProps.Account, "memberNo"),
	PropsMap::value_type(PosProps.CouponList, "coupon_list")
};
static PropsMap PosToServerProps(PropsMapPairs, PropsMapPairs + (sizeof(PropsMapPairs)/sizeof(PropsMapPairs[0])));

class FMPropsMap
{
public:
    static QString get(QString posProp) {
        PropsMap::iterator it = PosToServerProps.find(posProp);
        if(it != PosToServerProps.end()) {
            return it->second;
        }
        return posProp;
    }
};
#endif

#define ServerProps(posProp) FMPropsMap::get(posProp)

// 签名字段
const static QString SignProps[] = {
    PosProps.AppId,
    PosProps.PartnerId,
    PosProps.T,
    ServerProps(PosProps.Fm_cmd),
    ServerProps(PosProps.StoreId),
    ServerProps(PosProps.PosId),
    ServerProps(PosProps.OperatorId)
};

// 默认要从POS请求中拷贝到服务请求的字段
const static QString DefaultProps[] = {
    PosProps.StoreId,
    PosProps.PosId,
    PosProps.OperatorId,
    PosProps.BussinessDate
};

// 删除指针宏
#define del_p(p)                \
        if ((p) != nullptr) {   \
            delete p;           \
            p = nullptr;        \
        }                       \

#ifndef ERRORTYPE
#define ERRORTYPE
/**
*   error info.
*/
enum {
    FM_API_SUCCESS = 100,
    FM_API_ERROR,
    FM_API_TIMEOUT,
    FM_API_BADJSON,
    FM_API_NETWORERROR,
    FM_API_SERVERERROR,
    FM_API_WINDOWCLOSE
};

// 返回错误信息的json
#define ErrorMsgJson    "{\"statusCode\":%1,\"msg\":\"%2\",\"prompt\":0}"
#define ErrorNeedPayCode "fmv:请使用支付码付款"
typedef std::map<const int, const char*> FMErrorMap;

const FMErrorMap::value_type fm_error_pairs[] =
{
    FMErrorMap::value_type(FM_API_SUCCESS, "Success"),
    FMErrorMap::value_type(FM_API_ERROR, "Error"),
    FMErrorMap::value_type(FM_API_TIMEOUT, "Timeout"),
    FMErrorMap::value_type(FM_API_BADJSON, "Invalid json data"),
    FMErrorMap::value_type(FM_API_NETWORERROR, "Network error"),
    FMErrorMap::value_type(FM_API_SERVERERROR, "Server error"),
    FMErrorMap::value_type(FM_API_WINDOWCLOSE, "Window is closed")
};

const FMErrorMap fm_error(fm_error_pairs, fm_error_pairs + (sizeof fm_error_pairs / sizeof fm_error_pairs[0]));

#endif



#define AppDirPath qApp->applicationDirPath()

#define QuitCMD "{\"reqType\":-1}"

#endif // GLOBAL_H
