﻿#ifndef FMP_VIP_SETTINGS_H
#define FMP_VIP_SETTINGS_H

#include <QObject>
#include <QVariant>
#include <fmp_logger_i.h>

class FMPSettingsInterface;

class FMPVipSettings : public QObject
{
    Q_OBJECT
public:
    static FMPVipSettings *instance();
    void init(FMPSettingsInterface *settings);

    QString getServerUrl();

private:
    explicit FMPVipSettings(QObject *parent = 0);

    QVariant _GetValue(const QString &key, QVariant defaultValue = 0);
    bool _SetValue(const QString &key, QVariant value);

private:
    FMPSettingsInterface *_settings;
};

#endif // FMP_VIP_SETTINGS_H
