﻿#include <fmp_logger_i.h>
#include "fmp_ve_handlers.h"
#include "fmp_vip.h"

FMPStartEventHandler::FMPStartEventHandler(ctkPluginContext *ctx, FMPVip *vip)
    : FMPVipEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_ACK_START "/"
                          + QString::number(ctx->getPlugin()->getPluginId()), vip),
      _ctx(ctx)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = _topic;
    _ctx->registerService<ctkEventHandler>(this, props);
}


void FMPStartEventHandler::handleEvent(const ctkEvent &event)
{
    if (_vip) {
        if (event.getProperty(FMP_PROPKEY_AGREED).toBool()) {
            _vip->TriggerInit();
        }
        else {
            FMP_WARN() << "Refused start request" << event.getTopic();
        }
    }
    else {
        FMP_DEBUG() << "No handler instance for event" << event.getTopic();
    }
}
