﻿/*
 * Copyright (c) 2016, 上海非码网络科技有限公司
 * All rights reserved.
 *
 */
#ifndef FMP_PLUGIN_I_H
#define FMP_PLUGIN_I_H

#include <fmp_base_i.h>
#include <fmp_logger_i.h>
#include <fmp_manager_i.h>
#include <QSemaphore>
#include <ctkPluginContext.h>
#include <service/event/ctkEventAdmin.h>

class ctkPluginContext;

class FMPluginInterface : public FMPBaseInterface
{
public:
    virtual         ~FMPluginInterface() { _semaphore.release(); }

    /**
     * 业务插件启动只能请求启动，由事件订阅者决定是否允许启动
     * -允许：订阅者通知业务插件，业务插件事件处理器触发 TriggerInit
     * -拒绝：订阅者通知业务插件
     * @brief StartService
     * @return
     */
    virtual int     StartService()
    {
        QString topic = FMP_TOPICS_SERVICES;
        topic += FMPE_SERVICE_REQ_START;
        topic += "/" + QString::number(GetPluginId());
        return PostEvent(topic);
    }


    /**
     * 默认异步启动插件，以确保业务资源释放都在主线程中
     * @brief StopService
     * @return
     */
    virtual int     StopService()
    {
        TriggerUninit();
        _semaphore.acquire(1);
        return FMP_SUCCESS;
    }

    virtual long    GetPluginId() const { return GetContext()->getPlugin()->getPluginId(); }


 protected:
    virtual void    TriggerInit() = 0;
    virtual void    TriggerUninit() = 0;

    virtual void    OnTriggerInit()
    {
        InitService();
        _semaphore.release(1);
    }

    virtual void    OnTriggerUninit()
    {
        UninitService();
        _semaphore.release(1);
    }

    int             PostEvent(const QString &topic, const FMPProps &pps = FMPProps())
    {
        ctkEventAdmin* event_admin = FMP::GetService<ctkEventAdmin>();
        if (event_admin) {
            ctkEvent ctk_event(topic, pps);
            event_admin->postEvent(ctk_event);
            FMP_INFO() << "Posted event" << topic << "Properties:" << pps;
            return FMP_SUCCESS;
        }
        else {
            FMP_WARN() << topic << "not send: Event admin not available.";
        }

        return FMP_FAILURE;
    }

protected:
    QSemaphore          _semaphore;
};

Q_DECLARE_INTERFACE(FMPluginInterface, "com.fmp.plugin")


#endif // FMP_PLUGIN_I_H
