﻿/*
 * Copyright (c) 2016, 上海非码网络科技有限公司
 * All rights reserved.
 *
 */
#ifndef FMP_BASE_I_H
#define FMP_BASE_I_H

#include "../common/fmp_constants.h"
#include "../common/fmp_types.h"
#include "../common/fmp_events.h"

class ctkPluginContext;
typedef ctkPluginContext* FMPContext;

class FMPBaseInterface
{
public:
    /**
      * 启动插件服务，同一模块只需要初始化一次就可。
      * \return 成功返回 \link FMP_SUCCESS \endlink。
      *         失败返回 \link FMP_FAILURE \endlink。
      *                       FMP_REFUSED
      */
    virtual int     StartService() { InitService(); return FMP_SUCCESS; }

    /**
     * 停止插件服务
     * @brief StopService
     * @return
     */
    virtual int     StopService() { UninitService(); return FMP_SUCCESS; }

    /**
     * 获取服务对应的插件编号
     * @brief GetName
     * @return
     */
    virtual long    GetPluginId() const = 0;

protected:
    virtual void    InitService() = 0;
    virtual void    UninitService() = 0;
//    virtual void    IsAutoStart() = 0;

    /**
     * 异步发送插件事件
     * @brief PostEvent
     * @param topic 事件话题
     * @param props 话题参数
     * @return
     */
    virtual int                 PostEvent(const QString &topic, const FMPProps &pps) = 0;

    virtual const FMPContext    GetContext() const = 0;
};

Q_DECLARE_INTERFACE(FMPBaseInterface, "com.fmp.base")


#endif // FMP_BASE_I_H
