﻿#ifndef DSINGLEAPPLICATION_H
#define DSINGLEAPPLICATION_H

#include <QWidget>
#include <QFileInfo>
#include <QLocalSocket>
#include <QLocalServer>
#include <QApplication>


class FMSingleApplication : public QApplication
{
    Q_OBJECT
public:
    explicit FMSingleApplication(int &argc, char **argv)
        :QApplication(argc, argv),
         widget(NULL),
         isRunning(false),
         localServer(NULL)
    {
        //! 取应用程序名作为LocalServer的名字
        serverName = QFileInfo(QCoreApplication::applicationFilePath()).fileName();

        InitLocalConnection();
    }


    /** 功能:判断是否有实例在运行
     *  返回:true有 false无
     **/
    bool IsRunning() { return isRunning; }

    /** 功能:设置主窗口句柄
     *  参数:主窗口句柄
     *  返回:NULL
     **/
    void SetWidget(QWidget* w) { widget = w; }

private slots:
    //! 有新连接时触发
    void OnNewLocalConnection() { ActivateWindow(); }

private:
    //! 初始化本地连接
    void InitLocalConnection()
    {
       isRunning = false;

       QLocalSocket socket;
       socket.connectToServer(serverName);
       if(socket.waitForConnected(500)) {
           isRunning = true;
           return;
       }

       //! 连接不上服务器，就创建一个
       NewLocalServer();
    }


    //! 创建服务端
    void NewLocalServer()
    {
        localServer = new QLocalServer(this);
        connect(localServer, SIGNAL(newConnection()), this, SLOT(OnNewLocalConnection()));
        if(!localServer->listen(serverName)) {
            //! 此时监听失败，可能是程序崩溃时,残留进程服务导致的,移除之
            if(localServer->serverError() == QAbstractSocket::AddressInUseError) {
                QLocalServer::removeServer(serverName);
                localServer->listen(serverName); //! 再次监听
            }
        }
    }


    //! 激活窗口
    void ActivateWindow()
    {
        if(NULL != widget) {
            widget->show();
            widget->raise();
            widget->activateWindow();
        }

        return;
    }


    QWidget *       widget;          //! 主窗口句柄
    bool            isRunning;       //! 是否已经有实例在运行
    QLocalServer *  localServer;     //! 本地socket Server
    QString         serverName;      //! 服务名称
};

#endif // DSINGLEAPPLICATION_H
