﻿#ifndef FMP_SYNCER_P_H
#define FMP_SYNCER_P_H

#include "fmp_syncer.h"
#include <QThread>
#include <QSharedPointer>

class FMPSettingsInterface;
class FMPNetworkInterface;
class FMPLoggerInterface;

class FMPSyncerPrivate : public QThread
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPSyncer)
public:
    explicit        FMPSyncerPrivate(FMPSyncer *q);

public:
    /**
     * @brief Init
     * @return
     */
    int             Init();
    /**
     * @brief Uninit
     * @return
     */
    int             Uninit();


    QString         GetPartnerId();
    QString         GetStoreId();
    QString         GetPosId();
    int             GetRequestTimeout();
    int             GetSyncInterval();
    QString         GetTaskUrl();
    QString         GetTaskReportUrl();
    QString         GetDownloadPath();
    QString         GetDeployPath();

    void            SetStoreId(const QString &id);
    void            SetPosId(const QString &id);
    void            SetDownloadTimeout(int sec);
    void            SetRequestTimeout(int sec);
    void            SetSyncInterval(int sec);
    void            SetTaskUrl(const QString &url);
    void            SetTaskReportUrl(const QString &url);
    void            SetDownloadPath(const QString &path);
    void            SetDeployPath(const QString &path);

private:
    QVariant        _GetValue(const QString& k, QVariant default_val);
    bool            _SetValue(const QString& k, QVariant val);

public:
    //! QThread
    void            run();

    /**
     * @brief ReportTask
     * 汇报升级任务
     * @param id
     * @param msg
     * @param state
     */
    void            ReportTask(const QString& id = QString(), const QString& msg = QString(), const QString& state = QString());
    /**
     * @brief ReportUploadTask
     * 汇报上传任务
     */
    void            ReportUploadTask(bool);
    /**
     * @brief GetTask
     * 获取升级任务
     * @param task_jo 任务 Json 对象
     * @return 是否成功获取
     */
    bool            GetTask(QJsonObject &task_jo);
    /**
     * @brief UploadFiles
     * 上传文件
     * @param files 文件列表
     * @return 是否成功上传所有文件
     */
    bool            UploadFiles(const QStringList &files);
    /**
     * @brief GetLatestFiles
     * 获取需要更新的文件
     * @param url 接口地址
     * @param latest_files 需要更新的文件
     * @return 是否成功获取
     */
    bool            GetLatestFiles(const QString &url, QMap<QString, QString> &latest_files);

    /**
     * @brief RetainLatestFiles
     * 从所有文件只保留需要更新的文件
     * @param all_files 服务器所有文件信息
     * @param latest_files 需要更新的文件
     * @return
     */
    bool            RetainLatestFiles(const QMap<QString, QString>& all_files, QMap<QString, QString>& latest_files);

    /**
     * @brief GetFileMd5
     * 获取文件 Md5
     * @param filePath 文件路径
     * @return 目标文件 Md5 串
     */
    QString         GetFileMd5(const QString& file_path);

    /**
     * @brief DownloadFiles
     * 下载所有文件
     * @param downloadUrl 下载地址
     * @param files 需要下载的文件
     * @return 已经成功下载的文件名列表
     */
    QStringList     DownloadFiles(const QString &url, const QMap<QString, QString> files);

signals:

    /**
     * @brief upgradeReady
     * 通知更新已准备好
     */
    void            UpgradeReady();
public:
    bool                    _inited;
    FMPSyncer              *q_ptr;
    FMPSettingsInterface*   sets;
    FMPNetworkInterface*    nw;

    QString                 _deploy_dir;    //! 记录程序所在的目录
};

#endif // FMP_SYNCER_P_H
