﻿#ifndef FMP_SYNCER_I_H
#define FMP_SYNCER_I_H

#include <fmp_base_i.h>

#include "fmp_syncer_def.h"

/**
 * @brief 同步服务接口类 FMPSyncerInterface
 * 非业务插件接口，必须继承自 BaseInterface
 */
class FMPSyncerInterface : public FMPBaseInterface
{
public:
    /**
     * @brief GetPartnerId
     * 获取合作方编号
     */
    virtual QString         GetPartnerId() const = 0;

    /**
     * @brief GetStoreId / SetStoreId
     * 获取/设置门店编号
     */
    virtual QString         GetStoreId() const = 0;
    virtual void            SetStoreId(const QString &id) = 0;

    /**
     * @brief GetRequestTimeout / SetRequestTimeout
     * 获取/设置请求数据超时时间（秒）
     */
    virtual int             GetRequestTimeout() const = 0;
    virtual void            SetRequestTimeout(int sec) = 0;

    /**
     * @brief GetSyncInterval / SetSyncInterval
     * 获取/设置同步时间间隔（毫秒）
     */
    virtual int             GetSyncInterval() const = 0;
    virtual void            SetSyncInterval(int ms) = 0;

    /**
     * @brief GetTaskUrl / SetTaskUrl
     * 获取/设置检测升级任务的URL
     */
    virtual QString         GetTaskUrl() const = 0;
    virtual void            SetTaskUrl(const QString &url) = 0;

    /**
     * @brief GetTaskReportUrl / SetTaskReportUrl
     * 获取/设置汇报升级结果的URL
     */
    virtual QString         GetTaskReportUrl() const = 0;
    virtual void            SetTaskReportUrl(const QString &url) = 0;

    virtual QString         GetDeployPath() const = 0;
    virtual void            SetDeployPath(const QString &url) = 0;

    virtual QString         GetDownloadPath() const = 0;
    virtual void            SetDownloadPath(const QString &path) = 0;

//    /**
//     * @brief GetUploadReportUrl
//     * 获取汇报上传结果的URL
//     * @return
//     */
//    virtual QString         GetUploadReportUrl() const = 0;

//    /**
//     * @brief GetFtpUrl
//     * @return
//     */
//    virtual QString         GetFtpUrl() const = 0;

};

Q_DECLARE_INTERFACE(FMPSyncerInterface, "fmp.syncer")

#endif // FMP_SYNCER_I_H
