﻿#ifndef FMP_SYNCER_H
#define FMP_SYNCER_H

#include <QObject>
#include <ctkPluginContext.h>
#include "fmp_syncer_i.h"

class FMPSyncerPrivate;

class FMPSyncer : public QObject, public FMPSyncerInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPSyncerInterface)
    Q_DECLARE_PRIVATE(FMPSyncer)

public:
    explicit            FMPSyncer(const FMPContext ctx);
    virtual             ~FMPSyncer();

    virtual long        GetPluginId() const { return GetContext()->getPlugin()->getPluginId(); }

protected:
    //! BaseInterface
    void                InitService();
    void                UninitService();
    int                 PostEvent(const QString &topic, const FMPProps &pps = FMPProps());
    const FMPContext    GetContext() const { return context; }
public:
    //! SyncInterface
    QString             GetPartnerId() const { return _partner_id; }
    QString             GetStoreId() const { return _store_id; }
    QString             GetPosId() const { return _pos_id; }
    int                 GetRequestTimeout() const { return _req_timeout; }
    int                 GetSyncInterval() const { return _sync_interval; }
    QString             GetTaskUrl() const { return _task_url; }
    QString             GetTaskReportUrl() const { return _task_report_url; }
    QString             GetDownloadPath() const { return _download_path; }
    QString             GetDeployPath() const { return _deploy_path; }

    void                SetStoreId(const QString &id);
    void                SetPosId(const QString &id);
    void                SetRequestTimeout(int sec);
    void                SetSyncInterval(int ms);
    void                SetTaskUrl(const QString &url);
    void                SetTaskReportUrl(const QString &url);
    void                SetDownloadPath(const QString &path);
    void                SetDeployPath(const QString &path);

private:
    FMPSyncerPrivate   *d_ptr;
    const FMPContext    context;
    int                 _req_timeout;
    int                 _sync_interval;
    QString             _partner_id;
    QString             _store_id;
    QString             _pos_id;
    QString             _task_url;
    QString             _task_report_url;
    QString             _upload_url;
    QString             _upload_report_url;
    QString             _download_path;
    QString             _deploy_path;
};

#endif // FMP_SYNCER_H
