#include "fmp_syncer.h"
#include "fmp_syncer_p.h"
#include <QDebug>

FMPSyncer::FMPSyncer(const FMPContext ctx)
    : context(ctx),
      d_ptr(new FMPSyncerPrivate(this)),
      _partner_id(d_ptr->GetPartnerId()),
      _store_id(d_ptr->GetStoreId()),
      _pos_id(d_ptr->GetPosId()),
      _sync_interval(d_ptr->GetSyncInterval()),
      _req_timeout(d_ptr->GetRequestTimeout()),
      _task_url(d_ptr->GetTaskUrl()),
      _task_report_url(d_ptr->GetTaskReportUrl()),
      _deploy_path(d_ptr->GetDeployPath()),
      _download_path(d_ptr->GetDownloadPath())

{
    StartService();
}

FMPSyncer::~FMPSyncer()
{
    StopService();

    if (d_ptr) {
        delete d_ptr;
        d_ptr = nullptr;
    }
}

void FMPSyncer::InitService()
{
    d_func()->Init();
}

void FMPSyncer::UninitService()
{
    if (d_ptr) {
        d_ptr->terminate();
        delete d_ptr;
        d_ptr = nullptr;
    }
}

int FMPSyncer::PostEvent(const QString &topic, const FMPProps &pps)
{
    Q_UNUSED(topic);
    Q_UNUSED(pps);

    return FMP_NOIMPL;
}

void FMPSyncer::SetStoreId(const QString &id)
{
    d_func()->SetStoreId(id);
}

void FMPSyncer::SetRequestTimeout(int sec)
{
    d_func()->SetRequestTimeout(sec);
}

void FMPSyncer::SetSyncInterval(int ms)
{
    d_func()->SetSyncInterval(ms);
}

void FMPSyncer::SetTaskUrl(const QString &url)
{
    d_func()->SetTaskUrl(url);
}

void FMPSyncer::SetTaskReportUrl(const QString &url)
{
    d_func()->SetTaskReportUrl(url);
}

void FMPSyncer::SetDownloadPath(const QString &path)
{
    d_func()->SetDownloadPath(path);
}

void FMPSyncer::SetDeployPath(const QString &path)
{
    d_func()->SetDeployPath(path);
}
