﻿#include "scanningdialog.h"
#include "ui_scanningdialog.h"
#include "couponkeypad.h"
#include "fmp_logger_i.h"
#include <QDebug>
#include <Windows.h>
#include <QTimer>

ScanningDialog::ScanningDialog(QWidget * parent, Qt::WindowFlags f) :
    QDialog(parent, f),
    ui(new Ui::ScanningDialog)
{
    ui->setupUi(this);
    //setGeometry(0, 0, 350, 470);
    setWindowTitle(QString::fromLocal8Bit("非码卡券"));
    setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);
    //setWindowFlags(Qt::FramelessWindowHint);
    //setAutoFillBackground(false);  //这个不设置的话就背景变黑  
    setAttribute(Qt::WA_TranslucentBackground,true); 
    setAttribute(Qt::WA_QuitOnClose, false);
    
    //扫描动画
    scanningBar = new QPropertyAnimation( ui->labScaningBar, "geometry",this);
    connect( scanningBar, &QPropertyAnimation::finished, this, &ScanningDialog::animationEnd);
    animationUp = true;
    animationEnd();
    ui->labScaningBar->setFocus();
    
    //关闭按钮
    connect(ui->btnClose, &QPushButton::clicked, this, &ScanningDialog::onClose);
    //手动输入按钮
    connect(ui->btnManual, &QPushButton::clicked, this, &ScanningDialog::manualInput);
    
    QTimer::singleShot(1000, this, &ScanningDialog::timeOut);
}

void ScanningDialog::animationEnd()
{
    scanningBar->setDuration(1500);
    if(animationUp)
    {
        scanningBar->setStartValue( QRect( 0,310, 330,33));
        scanningBar->setEndValue( QRect( 0,407,330,33));
    }
    else
    {
        scanningBar->setStartValue( QRect( 0,407,330,33));
        scanningBar->setEndValue( QRect( 0,310, 330,33));
    }
    animationUp = !animationUp;
    scanningBar->start();
}

void ScanningDialog::manualInput()
{
    CouponKeypad keypad(this);
    if(keypad.exec() == QDialog::Accepted)
    {
        code = keypad.code;
        accept();
    }
}

void ScanningDialog::keyPressEvent(QKeyEvent *e)
{
    if( e->key() == Qt::Key_Enter || e->key() == Qt::Key_End  || e->key() == 16777220 )
    {
        accept();
        return;
    }
    code.append( e->text());
}

void ScanningDialog::onClose()
{
    scanningBar->stop();
    close();
}

void ScanningDialog::timeOut()
{
    qDebug() << "activateWindow";
    FMP_DEBUG() << "activateWindow";
    HWND hForeWnd = ::GetForegroundWindow();
    DWORD dwForeID = ::GetWindowThreadProcessId(hForeWnd,NULL);
    DWORD dwCurID = ::GetCurrentThreadId();
    ::AttachThreadInput(dwCurID,dwForeID,TRUE);

    ::SetWindowPos( (HWND)effectiveWinId(), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);

    showNormal();

    ::SetForegroundWindow((HWND)this->effectiveWinId());

    ::AttachThreadInput(dwCurID,dwForeID,FALSE);

    this->setFocus();
    ui->labScaningBar->setFocus();
}

ScanningDialog::~ScanningDialog()
{
    delete ui;
}