﻿#ifndef FMP_REDEEM_I_H
#define FMP_REDEEM_I_H

#include <fmp_plugin_i.h>

/**
 * 业务插件接口，必须继承自 FMPluginInterface
 * @brief The FMPRedeemInterface class
 */

class FMPRedeemInterface : public QObject, public FMPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPluginInterface)
public:
    explicit            FMPRedeemInterface() : FMPluginInterface()
    {
        connect(this, &FMPRedeemInterface::TriggerInit, this, &FMPRedeemInterface::OnTriggerInit);
        connect(this, &FMPRedeemInterface::TriggerUninit, this, &FMPRedeemInterface::OnTriggerUninit);
    }
    
    virtual QJsonObject Redeem(const double needPay, const QJsonArray& productsInfo) = 0; //券码核销
signals:
    void                TriggerInit();
    void                TriggerUninit();

protected slots:
    void                OnTriggerInit() { FMPluginInterface::OnTriggerInit(); }
    void                OnTriggerUninit() { FMPluginInterface::OnTriggerUninit(); }
};
Q_DECLARE_INTERFACE(FMPRedeemInterface, "fmp.redeem")

#endif // FMP_REDEEM_I_H

