﻿#ifndef FMP_REDEEM_H
#define FMP_REDEEM_H

#include "fmp_redeem_i.h"
#include "fmp_settings_i.h"
#include <QJsonObject>
#include <QJsonArray>
#include <QPointer>
class FMPStartEventHandler;
class FMPRedeem : public FMPRedeemInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPluginInterface)
    Q_INTERFACES(FMPRedeemInterface)
    
    enum {
        FM_API_SUCCESS = 100,
        FM_API_ERROR,
        FM_API_TIMEOUT,
        FM_API_BADJSON,
        FM_API_NETWORKERROR,
        FM_API_SERVERERROR,
        FM_API_WINDOWCLOSE,
        FM_API_TYPEERROR
    };

public:
    explicit            FMPRedeem(const FMPContext context);
    virtual             ~FMPRedeem();
    
    QJsonObject         Redeem(const double needPay, const QJsonArray& productsInfo); //券码核销
    
protected:
    const FMPContext    GetContext() const { return _context; }

protected slots:
    void                InitService();
    void                UninitService();
    
private:
    QJsonObject         SendRequest(const QByteArray &reqData);
    QJsonObject         ShowForUnConsum(QJsonObject json);
    QJsonObject         ShowForHasConsum(QJsonObject json);
    QJsonObject         ShowForInvalid(QJsonObject json);
    QJsonObject         ShowForExpird(QJsonObject json);
    QJsonObject         ShowForErr(QJsonObject json);
    QJsonObject         ShowForMismatch(QJsonObject json);
    int                 ZH_caclChkValue(char * pJsonData, int startPos, int endPos);
    QByteArray          CheckSendArray( QByteArray & jsonArray);
    bool                IsContinue(int couponAmount);
    QJsonValue          SearchJsonObject(QJsonObject& searchJson, QString searchKey);
    QJsonValue          SearchJsonArray(QJsonArray& searchJson, QString searchKey);
private:
    bool                _inited;
    double              _needPay;
    QString             _store_id;
    QString             _station_id;
    QString             _operator_id;
    QString             _coupon;
    int                 _partner_id;
    QString             _url;
    QJsonArray          _products_info;
    int                 _clientReqCount;
    const FMPContext    _context;
    QPointer<FMPStartEventHandler> _ste_handler;
};

#endif // FMP_REDEEM_H

