#ifndef FMP_PE_HANDLERS_H
#define FMP_PE_HANDLERS_H

#include <QObject>
#include <service/event/ctkEventConstants.h>
#include <service/event/ctkEventHandler.h>

class FMPRedeem;

class FMPRedeemEventHandler : public ctkEventHandler
{
public:
    explicit FMPRedeemEventHandler(const QString &topic, FMPRedeem *redeem) : _redeem(redeem), _topic(topic) {}

protected:
    FMPRedeem*            _redeem;
    const QString       _topic;
};

/**
 * 升级事件处理类
 * @brief The FMPUpgradeEventHandler class
 */
class FMPStartEventHandler : public QObject, public FMPRedeemEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)
public:
    explicit            FMPStartEventHandler(FMPRedeem *redeem);
    void                handleEvent(const ctkEvent &event);
};


/**
 * 升级事件处理类(网络)
 * @brief TheNetWorkFMPUpgradeEventHandler class
 */
class FMPNetWorkEventHandler : public QObject, public FMPRedeemEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)
public:
    explicit            FMPNetWorkEventHandler(FMPRedeem *redeem);
    void                handleEvent(const ctkEvent &event);
};

#endif // FMP_PE_HANDLERS_H

