#include <fmp_logger_i.h>
#include "fmp_pe_handlers.h"
#include "fmp_redeem.h"

FMPStartEventHandler::FMPStartEventHandler(FMPRedeem *redeem)
    : FMPRedeemEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_ACK_START "/" + QString::number(redeem->GetPluginId()), redeem)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = _topic;
    FMP::RegisterService<ctkEventHandler>(this, props);
}

void FMPStartEventHandler::handleEvent(const ctkEvent &event)
{
    if (_redeem) {
        if (event.getProperty(FMP_PROPKEY_AGREED).toBool()) {
            _redeem->TriggerInit();
        }
        else {
            FMP_WARN() << "Refused start request" << event.getTopic();
        }
    }
    else {
        FMP_DEBUG() << "No handler instance for event" << event.getTopic();
    }
}


FMPNetWorkEventHandler::FMPNetWorkEventHandler(FMPRedeem *redeem)
    : FMPRedeemEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_ACK_START "/" + QString::number(redeem->GetPluginId()), redeem)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = _topic;
    FMP::RegisterService<ctkEventHandler>(this, props);
}

void FMPNetWorkEventHandler::handleEvent(const ctkEvent &event)
{
    if (_redeem) {
        if (event.getProperty(FMP_PROPKEY_AGREED).toBool()) {
            _redeem->TriggerInit();
        }
        else {
            FMP_WARN() << "Refused start request" << event.getTopic();
        }
    }
    else {
        FMP_DEBUG() << "No handler instance for event" << event.getTopic();
    }
}