﻿#include "consumokdialog.h"
#include "ui_consumokdialog.h"

ConsumOkDialog::ConsumOkDialog(QWidget * parent, Qt::WindowFlags f) :
    QDialog(parent, f),
    ui(new Ui::ConsumOkDialog)
{
    ui->setupUi(this);
    setWindowTitle(QString::fromLocal8Bit("非码卡券"));
    setWindowFlags(windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);
    setAutoFillBackground(false);  //这个不设置的话就背景变黑  
    setAttribute(Qt::WA_TranslucentBackground,true); 
    setAttribute(Qt::WA_QuitOnClose, false);
    connect( ui->btnConsumOk, &QPushButton::clicked, this, &ConsumOkDialog::accept);
}

ConsumOkDialog::~ConsumOkDialog()
{
    delete ui;
}

void ConsumOkDialog::showConsumOk(const QString& act_name, const QString& code_name, const QString& time_name, const QString& coupon, QWidget *parent)
{
    ConsumOkDialog v(parent);
//    v.setGeometry( 0,0,350,470);

    v.ui->labCode->setText( coupon);
    v.ui->labActName->setText( act_name);
    v.ui->labTime->setText( time_name);
    v.ui->labCodeName->setText( code_name);
    v.exec();
}