#ifndef FMPNETWORKREQUEST_H
#define FMPNETWORKREQUEST_H

#include <QObject>

/**
 * @brief The FMPHttpRequest class
 */
class FMPSocketRequest
{
public:
    explicit        FMPSocketRequest(const QString &h, ushort p, const QByteArray&d)
        : host(h),
          port(p),
          data(d)
    {}
    ushort          port;
    QString         host;
    QByteArray      data;
};

/**
 * @brief The FMPHttpRequest class
 */
class FMPHttpRequest : public FMPSocketRequest
{
public:
    explicit        FMPHttpRequest(const QString &u, const QByteArray& d = QByteArray())
        : FMPSocketRequest(u, 80, d),
          url(u),
          timeout(30000)
    {
        if (!u.contains("://")) {
            url = "http://" + u;
        }

        host = url.section("/", 0, 2);
        port = host.section(":", 2, 2).toInt();
        host = host.section(":", 0, 1);
        path = url.section("/", 3);
    }

    int                             timeout;
    QString                         url;
    QString                         path;
    QMap<QByteArray, QByteArray>    headers;
};


#endif // FMPNETWORKREQUEST_H
