#ifndef FMPNETWORKREPLY_H
#define FMPNETWORKREPLY_H

#include <QObject>
#include <QSharedPointer>
#include <QEventLoop>
#include <QDebug>

class FMPSocketReply : public QObject
{
    Q_OBJECT
public:
    enum
    {
        NO_ERROR, UNKNOWN_ERROR
    };

    explicit                FMPSocketReply(QObject *parent = 0);
    virtual                 ~FMPSocketReply()
    {
        qDebug() << "Reply Destroyed";
    }

    virtual int             WaitResponse();
    virtual QByteArray      Response();

    int                     Error() const { return _error; }
    QString                 ErrorString() const { return _error_str; }

    void                    SetError(int error);
    void                    SetErrorString(const QString &err_str);
    void                    SetResponse(const QByteArray &response);
    void                    Finish(QSharedPointer<FMPSocketReply> reply);

signals:
    void                    Finished(QSharedPointer<FMPSocketReply> reply);

protected:
    int                     _error;
    QString                 _error_str;
    QByteArray              _response;
};


/**
 * @brief The FMPHttpReply class
 */
class QNetworkReply;

class FMPHttpReply : public FMPSocketReply
{
    Q_OBJECT
public:
    explicit                FMPHttpReply(QObject *parent = 0) : FMPSocketReply(parent){}
    virtual                 ~FMPHttpReply() {}

signals:
    void                    Finished(QSharedPointer<FMPHttpReply> reply);
};

#endif // FMPNETWORKREPLY_H
