#include "fmp_nw_reply.h"

FMPSocketReply::FMPSocketReply(QObject *parent) : QObject(parent)
{
    qRegisterMetaType<QSharedPointer<FMPSocketReply> >("FMPSockReplyPointer");
}

int FMPSocketReply::WaitResponse()
{
    QEventLoop evt;
    connect(this, SIGNAL(Finished(QSharedPointer<FMPSocketReply>)), &evt, SLOT(quit()));
    evt.exec();

    return _error;
}


QByteArray FMPSocketReply::Response()
{
    return _response;
}

void FMPSocketReply::SetError(int error)
{
    _error = error;
}

void FMPSocketReply::SetErrorString(const QString &err_str)
{
    _error_str = err_str;
}

void FMPSocketReply::SetResponse(const QByteArray &response)
{
    _response = response;
}

void FMPSocketReply::Finish(QSharedPointer<FMPSocketReply> reply)
{
    emit Finished(reply);
}
