﻿#ifndef FMP_NETWORK_I_H
#define FMP_NETWORK_I_H

#include <fmp_base_i.h>
#include "fmp_nw_request.h"
#include "fmp_nw_reply.h"
#include <QSharedPointer>
#include <ctkPluginContext.h>

typedef QSharedPointer<FMPHttpReply> FMPHttpReplyPointer;
typedef QSharedPointer<FMPSocketReply> FMPSockReplyPointer;

class FMPNetworkInterface : public FMPBaseInterface
{
public:
    //! BaseInterface
    virtual long        GetPluginId() const { return GetContext()->getPlugin()->getPluginId(); }
    virtual FMPHttpReplyPointer     HttpGet(const FMPHttpRequest &req) = 0;
    virtual FMPHttpReplyPointer     HttpPost(const FMPHttpRequest &req, const QByteArray &data) = 0;
    virtual FMPHttpReplyPointer     HttpPut(const FMPHttpRequest &req, const QByteArray &data) = 0;
    virtual FMPSockReplyPointer     Send(const FMPSocketRequest &req) = 0;

    FMPHttpReplyPointer             HttpGet(const QString &url)
    {
        return HttpGet(FMPHttpRequest(url));
    }

    FMPHttpReplyPointer             HttpPost(const QString &url, const QByteArray &data)
    {
        FMPHttpRequest req(url);
        return HttpPost(req, data);
    }

    FMPHttpReplyPointer             HttpPut(const QString &url, const QByteArray &data)
    {
        return HttpPut(FMPHttpRequest(url), data);
    }

    FMPSockReplyPointer             Send(const QString &host, ushort port, const QByteArray &data)
    {
        return Send(FMPSocketRequest(host, port, data));
    }
};


Q_DECLARE_INTERFACE(FMPNetworkInterface, "fmp.network")

#endif // FMP_NETWORK_I_H
