﻿#ifndef FMPNETWORK_H
#define FMPNETWORK_H

#include <QObject>
#include "fmp_network_i.h"

class QTimer;
class FMPNetworkPrivate;

class FMPNetwork : public QObject, public FMPNetworkInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPNetworkInterface)
    Q_DECLARE_PRIVATE(FMPNetwork)

public:
    explicit                FMPNetwork(const FMPContext ctx);

    //! 基础插件接口
protected:
    void                    InitService();
    void                    UninitService();
    int                     PostEvent(const QString &topic, const FMPProps &pps);
    const FMPContext        GetContext() const { return context; }


public:
    //! 网络服务接口
    FMPHttpReplyPointer     HttpGet(const FMPHttpRequest &req);
    FMPHttpReplyPointer     HttpPost(const FMPHttpRequest &req, const QByteArray &data);
    FMPHttpReplyPointer     HttpPut(const FMPHttpRequest &req, const QByteArray &data);
    FMPSockReplyPointer     Send(const FMPSocketRequest &req);

private:
    FMPNetworkPrivate*      d_ptr;
    const FMPContext        context;
};

/**
 * FMPNetwork 私有实现类
 */
class QNetworkAccessManager;
typedef QMap<QNetworkAccessManager*, FMPSockReplyPointer>   FMPNetReqMap;
typedef QMap<QNetworkAccessManager*, QTimer*>               FMPNetTimerMap;

class FMPNetworkPrivate : public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPNetwork)

public:
    explicit                FMPNetworkPrivate(FMPNetwork *q);

    void                    SetRequestTimeout(int ms);
    FMPHttpReplyPointer     HttpGet(const FMPHttpRequest &req);
    FMPHttpReplyPointer     HttpPost(const FMPHttpRequest &req, const QByteArray &data);
    FMPHttpReplyPointer     HttpPut(const FMPHttpRequest &req, const QByteArray &data);
    FMPSockReplyPointer     Send(const FMPSocketRequest &req);

    FMPNetReqMap            req_map;
    FMPNetTimerMap          req_timer;
    FMPNetwork*             q_ptr;

public slots:
    void                    OnRequestFinished(QNetworkReply* reply);
    void                    OnRequestTimeout();

protected:
    void                    CleanRequest(QNetworkAccessManager *net_manager, int result);
};

#endif // FMPNETWORK_H
