﻿#include "fmp_network.h"
#include "fmp_nw_reply.h"
#include <fmp_logger_i.h>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QTimer>

FMPNetwork::FMPNetwork(const FMPContext ctx) :
    context(ctx),
    d_ptr(new FMPNetworkPrivate(this))
{
}

void FMPNetwork::InitService()
{
    //! FMP_NOIMPL;
}

void FMPNetwork::UninitService()
{
    //! FMP_NOIMPL;
}

int FMPNetwork::PostEvent(const QString &topic, const FMPProps &pps)
{
    Q_UNUSED(topic);
    Q_UNUSED(pps);
    return FMP_NOIMPL;
}

FMPHttpReplyPointer FMPNetwork::HttpGet(const FMPHttpRequest &req)
{
    return d_func()->HttpGet(req);
}

FMPHttpReplyPointer FMPNetwork::HttpPost(const FMPHttpRequest &req, const QByteArray &data)
{
    return d_func()->HttpPost(req, data);
}

FMPHttpReplyPointer FMPNetwork::HttpPut(const FMPHttpRequest &req, const QByteArray &data)
{
    return d_func()->HttpPut(req, data);
}

FMPSockReplyPointer FMPNetwork::Send(const FMPSocketRequest &req)
{
    return d_func()->Send(req);
}

/**
 * FMPNetwork 私有实现类
 */
FMPNetworkPrivate::FMPNetworkPrivate(FMPNetwork *q)
    : q_ptr(q)
{
}

FMPHttpReplyPointer FMPNetworkPrivate::HttpGet(const FMPHttpRequest &r)
{
    QNetworkAccessManager *net_manager = new QNetworkAccessManager();

    QNetworkRequest req;
    req.setUrl(QUrl(r.url));
    QList<QByteArray> header_keys = r.headers.keys();
    foreach(QByteArray name, header_keys) {
        req.setRawHeader(name, r.headers[name]);
    }

    FMPHttpReplyPointer reply = FMPHttpReplyPointer(new FMPHttpReply());
    connect(net_manager, SIGNAL(finished(QNetworkReply*)), SLOT(OnRequestFinished(QNetworkReply*)));
    req_map[net_manager] = reply;
    QTimer *timer = new QTimer();
    req_timer[net_manager] = timer;

    QNetworkReply* net_reply = net_manager->get(req);

    connect(timer, SIGNAL(timeout()), SLOT(OnRequestTimeout()));
    timer->start(r.timeout);

    return reply;
}

FMPHttpReplyPointer FMPNetworkPrivate::HttpPost(const FMPHttpRequest &req, const QByteArray &data)
{
    FMPHttpReplyPointer reply;

    QNetworkAccessManager *net_manager = new QNetworkAccessManager();

    QNetworkRequest request;
    request.setUrl(QUrl(req.url));
    if (!req.headers.contains("Content-Type")) {
        request.setRawHeader("Content-Type", "application/json");
    }

    QList<QByteArray> header_keys = req.headers.keys();
    foreach(QByteArray name, header_keys) {
        request.setRawHeader(name, req.headers[name]);
    }

    reply = FMPHttpReplyPointer(new FMPHttpReply());
    connect(net_manager, SIGNAL(finished(QNetworkReply*)), SLOT(OnRequestFinished(QNetworkReply*)));
    req_map[net_manager] = reply;
    QTimer *timer = new QTimer();
    req_timer[net_manager] = timer;

    QNetworkReply* net_reply = net_manager->post(request, data);

    connect(timer, SIGNAL(timeout()), SLOT(OnRequestTimeout()));
    timer->start(req.timeout);

    return reply;
}

FMPHttpReplyPointer FMPNetworkPrivate::HttpPut(const FMPHttpRequest &req, const QByteArray &data)
{
    FMPHttpReplyPointer reply;
    return reply;
}

void FMPNetworkPrivate::OnRequestFinished(QNetworkReply *reply)
{
    QNetworkAccessManager *net_manager = reply->manager();

    if (req_map.contains(net_manager)) {
        FMPSockReplyPointer fmp_reply = req_map[net_manager];
        fmp_reply->SetResponse(reply->readAll());
        fmp_reply->SetError(reply->error());
        fmp_reply->Finish(fmp_reply);

        req_map.take(net_manager);
        QTimer *timer = req_timer.take(net_manager);
        timer->deleteLater();
        net_manager->deleteLater();
    }
}

void FMPNetworkPrivate::OnRequestTimeout()
{
    QTimer *timer = qobject_cast<QTimer*>(sender());
    QMap<QNetworkAccessManager*, QTimer*>::iterator iter = std::find(req_timer.begin(), req_timer.end(), timer);
    if (iter != req_timer.end()) {
        QNetworkAccessManager *net_manager = iter.key();
        FMPSockReplyPointer fmp_reply = req_map[net_manager];
        fmp_reply->SetError(QNetworkReply::TimeoutError);
        fmp_reply->SetErrorString("Request timeout");
        fmp_reply->Finish(fmp_reply);

        req_map.take(net_manager);
        QTimer *timer = req_timer.take(net_manager);
        timer->deleteLater();
        net_manager->deleteLater();
    }
    else {
        qDebug() << "Request not found. Just kill the timer.";
    }
}

FMPSockReplyPointer FMPNetworkPrivate::Send(const FMPSocketRequest &req)
{
    FMPSockReplyPointer reply;
    return reply;
}
