﻿#ifndef FMP_MANAGER_EVENT_HANDLERS_H
#define FMP_MANAGER_EVENT_HANDLERS_H

#include <QObject>
#include <service/event/ctkEventConstants.h>
#include <service/event/ctkEventHandler.h>

#include "fmp_manager_d.h"

class FMPluginManager;

/**
 * 管理器事件处理基类
 * @brief The FMPManagerEventHandler class
 */
class FMPManagerEventHandler : public QObject, public ctkEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)

public:
    explicit            FMPManagerEventHandler(const QString &t, FMPluginManager *pm);

protected:
    FMPluginManager*    pm;
    const QString       topic;
};

/**
 * 升级事件处理类
 * @brief The FMPUpgradeEventHandler class
 */
class FMPUpgradeEventHandler : public FMPManagerEventHandler
{
    Q_OBJECT
public:
    explicit            FMPUpgradeEventHandler(FMPluginManager *pm);

    void                handleEvent(const ctkEvent &event);

signals:
    void                upgrade(const QVariantList &pid_list);

private:
};

/**
 * 退出事件处理类
 * @brief The FMPQuitEventHandler class
 */
class FMPQuitEventHandler : public FMPManagerEventHandler
{
    Q_OBJECT
public:
    explicit            FMPQuitEventHandler(FMPluginManager *pm);

    void                handleEvent(const ctkEvent &event);

signals:
    void                quit();
};

#endif // FMP_MANAGER_EVENT_HANDLERS_H
