﻿#include <fmp_logger_i.h>
#include "fmp_me_handlers.h"
#include "fmp_manager.h"
#include <QCoreApplication>

/**
 * @brief 管理器事件默认构造函数
 */
FMPManagerEventHandler::FMPManagerEventHandler(const QString &t, FMPluginManager *pm)
    : pm(pm),
      topic(t)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = topic;
    FMP::RegisterService<ctkEventHandler>(this, props);
}


/**
 * @brief 升级事件处理方法
 */
FMPUpgradeEventHandler::FMPUpgradeEventHandler(FMPluginManager *pm)
    : FMPManagerEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_ACK_UPDATE, pm)
{
    connect(this, SIGNAL(upgrade(QVariantList)), this->pm, SLOT(UpgradeOldPlugins(QVariantList)));
}

void FMPUpgradeEventHandler::handleEvent(const ctkEvent &event)
{
    if (!event.getProperty(FMP_PROPKEY_PID_LIST).toList().isEmpty()) {
        emit upgrade(event.getProperty(FMP_PROPKEY_PID_LIST).toList());
    }
    else {
        FMP_DEBUG() << "No plugin ids." << event.getTopic();
    }
}

/**
 * @brief 退出事件处理方法
 */
FMPQuitEventHandler::FMPQuitEventHandler(FMPluginManager *pm)
    : FMPManagerEventHandler(FMP_TOPICS_QUIT, pm)
{
    connect(this, SIGNAL(quit()), this->pm, SLOT(OnStopService()));
}

void FMPQuitEventHandler::handleEvent(const ctkEvent &event)
{
    emit quit();
}

