﻿#ifndef FMPLUGINMANAGER_H
#define FMPLUGINMANAGER_H

#include <QObject>
#include <QStack>
#include <QFileInfo>
#include <QFileSystemWatcher>
#include "fmp_manager_i.h"
#include <ctkPluginEvent.h>
#include <ctkServiceEvent.h>
#include <ctkPluginFrameworkEvent.h>
#include <ctkPluginFrameworkFactory.h>

class FMPLoggerInterface;
class FMPSettingsInterface;
class FMPSyncerInterface;
struct ctkEventHandler;

typedef QList<QSharedPointer<ctkEventHandler> > FMPEventHandlerList;


class FMPluginManager : public QObject, FMPManagerInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPManagerInterface)

#if (QT_VERSION > QT_VERSION_CHECK(5,0,0))
  Q_PLUGIN_METADATA(IID "com_fmp_manager")
#endif

public:
    explicit        FMPluginManager();
    virtual         ~FMPluginManager();

protected:
    //! 基础接口
    void            InitService();
    void            UninitService();

    int             PostEvent(const QString &topic, const FMPProps &pps = FMPProps());

public:
    //! 管理器接口
    void            LoadNewPlugins();
    int             LoadPlugin(const QString &plugin);
    int             UpgradePlugin(long pid);
    int             SetProperties(const FMPProps &props);

public slots:
    void            OnStartService() { StartService(); }
    void            OnStopService() { StopService(); }

    void            UpgradeOldPlugins(const QVariantList &);

public slots:
    void            OnPluginsChanged(const QString &path);

protected:
    QFileInfo       GetPluginInfo(const QString &plugin_name, const QString &ver = QString());
    QStringList     GetNewPlugins();
    QVariantList    GetExpiredPlugins();
    const FMPContext    GetContext() const { return fwContext; }


private slots:
    void            OnFrameworkEvent(const ctkPluginFrameworkEvent& event);
    void            OnPluginEvent(const ctkPluginEvent& event);
    void            OnServiceEvent(const ctkServiceEvent& event);

private:
    QSharedPointer<ctkPluginFramework>  fw;
    FMPContext                          fwContext;
    QFileSystemWatcher                  pluginWatcher;

    FMPSettingsInterface*               setting;
    FMPSyncerInterface*                 syncer;

    FMPEventHandlerList                 eventHandlers;
    QStack<QSharedPointer<ctkPlugin> >  plugins;

    QJsonObject                         fwProps;
};

#endif // FMPLUGINMANAGER_H
