 #ifndef FMP_LOGGERSTREAM_H
#define FMP_LOGGERSTREAM_H
#include <QObject>
#include <QDebug>
#include <QDateTime>
#include "fmp_logger_i.h"

class FMPLogStream
{
public:
    enum {
        ERROR = 1, WARNING, INFO, DEBUG
    };
    explicit    FMPLogStream(short level, const char* file, const char* func, int line)
        : _level(level),
          _file(file),
          _func(func),
          _line(line)
    {
        _stream = new QDebug(&_content);
    }
    
    ~FMPLogStream()
    {
        FMPLoggerInterface *logger = FMPLoggerInterface::GetLogger();
        if (logger) {
            logger->Log(_level, _content, _file, _func, _line);
        }
        else {
            qDebug() << QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm:ss.zzz") << _content;
        }

        if (_stream) {
            delete _stream;
            _stream = nullptr;
        }
    }
    
    template<typename T>
    FMPLogStream& operator <<(const T& t)
    {
        QDebug & stream = *(_stream);

        stream.noquote() << t;

        return *this;
    }

protected:
    int                 _level;
    const char *        _file;
    const char *        _func;
    int                 _line;
    QDebug*             _stream;
    QString             _content;
};

//! 快速日志记录宏定义
#define FMP_LOG(lvl) FMPLogStream(lvl, __FILE__, __FUNCTION__, __LINE__)


#define FMP_DEBUG()  FMP_LOG(FMPLoggerInterface::LOG_DEBUG)
#define FMP_INFO()   FMP_LOG(FMPLoggerInterface::LOG_INFO)
#define FMP_WARN()   FMP_LOG(FMPLoggerInterface::LOG_WARNING)
#define FMP_ERROR()  FMP_LOG(FMPLoggerInterface::LOG_ERROR)


#endif // FMP_LOGSTREAM_H
