#ifndef FMP_LOGGER_P_H
#define FMP_LOGGER_P_H

#include "fmp_logger.h"

class FMPLoggerPrivate
{
    Q_DECLARE_PUBLIC(FMPLogger)
public:
    explicit            FMPLoggerPrivate(FMPLogger *q);
    int                 Init();
    int                 Uninit();
    short               GetLogLevel();
    void                SetLogLevel(short level);
    uint                GetMaxLogSize();
    void                SetMaxLogSize(uint sz);
    QString             GetLogPath();
    void                SetLogPath(const QString &path);

    //!
    void                Log(short level, const QString &msg, const char* file, const char* func, int line);
protected:
    bool                _SetValue(const QString &key, QVariant v);
    QVariant            _GetValue(const QString &key, QVariant default_val = 0);

public:
    bool                    _inited;
    FMPLogger              *q_ptr;
};

#endif // FMP_LOGGER_P_H
