﻿#ifndef FMP_LOGGER_I_H
#define FMP_LOGGER_I_H

#include <fmp_base_i.h>
#include <fmp_manager_i.h>
#include <ctkServiceReference.h>

#include "fmp_logger_def.h"

class FMPLoggerInterface;

/**
 * 非业务插件接口，必须继承自 BaseInterface
 * @brief The FMPLoggerInterface class
 */
class FMPLoggerInterface : public FMPBaseInterface
{
public:
    enum { LOG_ERROR = 1, LOG_WARNING, LOG_INFO, LOG_DEBUG };

    virtual long            GetPluginId() const { return GetContext()->getPlugin()->getPluginId(); }

    /**
     * 设置当前所在模块名（打印时根据模块，使打印）
     * @brief SetLoggerName
     * @param moduleName
     */
    virtual void            SetLoggerName(const QString &moduleName) = 0;

    /**
     * @brief Log
     * 函数方式记录日志
     * @param level
     * @param file
     * @param func
     * @param line
     */
    virtual void            Log(short level, const QString &msg, const char* file, const char* func, int line) = 0;

    /**
     * @brief GetLogLevel
     * 获取当前日志记录级别
     * @return
     */
    virtual short           GetLogLevel() const = 0;

    /**
     * @brief SetLogLevel
     * 设置当前日志级别
     * @param level
     */
    virtual void            SetLogLevel(short level) = 0;

    /**
     * @brief GetMaxFilesize
     * 获取日志文件最大容量(MB)
     * @return 0 默认大小   n MB
     */
    virtual uint            GetMaxFilesize() const = 0;

    /**
     * @brief SetMaxFilesize
     * 设置日志文件最大容量(MB)
     */
    virtual void            SetMaxFilesize(uint) = 0;

    /**
     * @brief GetFilename
     * 获取当前日志文件路径
     * @return 文件路径
     */
    virtual QString         GetFilename() const = 0;

    /**
     * @brief GetPath
     * 获取日志存储位置
     * @return
     */
    virtual QString         GetPath() const = 0;

    /**
     * @brief SetPath
     * 设置日志存储位置
     * @param path
     */
    virtual void            SetPath(const QString &path) = 0;


    static FMPLoggerInterface*  GetLogger(const QString &moduleName = QString())
    {
        FMPLoggerInterface* svc = FMP::GetService<FMPLoggerInterface>();
        if (svc) {
            svc->SetLoggerName(moduleName);
        }
        return svc;
    }
};

Q_DECLARE_INTERFACE(FMPLoggerInterface, "fmp.logger")


#include "fmp_logstream.h"

#endif // FMP_LOGGER_I_H
