#ifndef FMP_LOGGER_H
#define FMP_LOGGER_H

#include <QObject>
#include <QFile>
#include <QDebug>

#include "fmp_logger_i.h"

class FMPLoggerPrivate;

class FMPLogger : public QObject, public FMPLoggerInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPLoggerInterface)
    Q_DECLARE_PRIVATE(FMPLogger)
public:

    explicit            FMPLogger(const FMPContext ctx);
    ~FMPLogger();

protected:
    //! BaseInterface
    void                InitService();
    void                UninitService();

    int                 PostEvent(const QString &topic, const FMPProps &pps = FMPProps());

    const FMPContext    GetContext() const { return pluginContext; }

public:
    //! LogInterface
    void                SetLoggerName(const QString &modleName) { currentModule = modleName; }
    void                Log(short level, const QString &msg, const char* file, const char* func, int line);
    short               GetLogLevel() const;
    void                SetLogLevel(short level);
    uint                GetMaxFilesize() const;
    void                SetMaxFilesize(uint sz);
    QString             GetFilename() const;
    QString             GetPath() const;
    void                SetPath(const QString &path);
    QIODevice*          GetIODevice();

private:
    FMPLoggerPrivate   *d_ptr;
    short               _level;
    uint                _max_size;
    QFile              *_file;
    QString             _path;
    QString             currentModule;
    const FMPContext    pluginContext;
};

#endif // FMP_LOGGER_H
