/*=============================================================================

  Library: CTK

  Copyright (c) German Cancer Research Center,
    Division of Medical and Biological Informatics

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/


#include "fmp_logger_p.h"

FMPLogger::FMPLogger(const FMPContext ctx)
    : QObject(),
      pluginContext(ctx),
      d_ptr(new FMPLoggerPrivate(this)),
      _max_size(d_ptr->GetMaxLogSize()),
      _path(d_ptr->GetLogPath()),
      _file(0),
      _level(d_ptr->GetLogLevel())
{
    StartService();
}

FMPLogger::~FMPLogger()
{
    StopService();

    if (d_ptr) {
        delete d_ptr;
        d_ptr = nullptr;
    }
}

void FMPLogger::InitService()
{
    d_func()->Init();
}

void FMPLogger::UninitService()
{
    d_func()->Uninit();
}

void FMPLogger::Log(short level, const QString &msg, const char* file, const char* func, int line)
{
    d_func()->Log(level, msg, file, func, line);
}

uint FMPLogger::GetMaxFilesize() const
{
    return _max_size;
}

void FMPLogger::SetMaxFilesize(uint sz)
{
    d_func()->SetMaxLogSize(sz);
}

QString FMPLogger::GetFilename() const
{
    return _file->fileName();
}

QString FMPLogger::GetPath() const
{
    return _path;
}

void FMPLogger::SetPath(const QString &path)
{
    d_func()->SetLogPath(path);
}

QIODevice *FMPLogger::GetIODevice()
{
    return _file;
}

int FMPLogger::PostEvent(const QString &topic, const FMPProps &pps)
{
    Q_UNUSED(topic);
    Q_UNUSED(pps);
    return FMP_NOIMPL;
}

short FMPLogger::GetLogLevel() const
{
    return _level;
}

void FMPLogger::SetLogLevel(short level)
{
    d_func()->SetLogLevel(level);
}